/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagramImpl;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNViewDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.Lane;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

abstract class DefinitionsContextHelper<EdgeT extends Edge<ViewConnector<BPMNViewDefinition>, Node<? extends View<? extends BPMNViewDefinition>, ?>>, NodeT extends Node<View<? extends BPMNViewDefinition>, EdgeT>> {
    private final Map<String, ? extends NodeT> nodes;
    private final Node firstNode;

    public DefinitionsContextHelper(Graph<DefinitionSet, NodeT> graph) {
        this(graph, BPMNDiagramImpl.class);
    }

    public DefinitionsContextHelper(Graph<DefinitionSet, NodeT> graph, Class<?> nodeType) {
        this.firstNode = GraphUtils.getFirstNode(graph, nodeType);
        this.nodes = StreamSupport.stream(graph.nodes().spliterator(), false).filter(n -> !this.firstNode.getUUID().equals(n.getUUID())).collect(Collectors.toMap(Element::getUUID, Function.identity()));
    }

    public DefinitionsContextHelper(Node<?, ?> firstNode, Map<String, ? extends Node> nodes) {
        this.firstNode = firstNode;
        this.nodes = nodes;
    }

    public Stream<? extends NodeT> nodes() {
        return this.nodes.values().stream();
    }

    public NodeT getNode(String id) {
        return (NodeT)((Node)this.nodes.get(id));
    }

    public Node firstNode() {
        return this.firstNode;
    }

    public Stream<EdgeT> edges() {
        return this.nodes().flatMap(e -> Stream.concat(e.getInEdges().stream(), e.getOutEdges().stream())).distinct().filter(e -> this.isViewConnector(e));
    }

    public Stream<EdgeT> dockEdges() {
        return this.nodes().flatMap(e -> Stream.concat(e.getInEdges().stream(), e.getOutEdges().stream())).distinct().filter(e -> this.isDock(e));
    }

    public Stream<EdgeT> childEdges() {
        return this.nodes().flatMap(e -> Stream.concat(e.getInEdges().stream(), e.getOutEdges().stream())).distinct().filter(e -> this.isChild(e));
    }

    public Stream<NodeT> childNodes() {
        return this.childEdges().map(edgeT -> edgeT.getTargetNode());
    }

    public DefinitionsBuildingContext withRootNode(String nodeId) {
        return new DefinitionsBuildingContext((Node<?, ?>)this.getNode(nodeId), this.findEdgesBydId(nodeId));
    }

    public DefinitionsBuildingContext withRootNode(Node<?, ?> node) {
        return new DefinitionsBuildingContext(node, this.findEdgesBydId(node.getUUID()));
    }

    private Map<String, Node> findEdgesBydId(String nodeId) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        this.childEdges().filter(e -> e.getSourceNode().getUUID().equals(nodeId)).map(Edge::getTargetNode).forEach(n -> nodes.put(n.getUUID(), (Node)n));
        return nodes;
    }

    private boolean isChild(EdgeT e) {
        return e.getContent() instanceof Child;
    }

    private boolean isDock(EdgeT e) {
        return e.getContent() instanceof Dock;
    }

    private boolean isViewConnector(EdgeT e) {
        return e.getContent() instanceof ViewConnector;
    }

    public Stream<? extends NodeT> lanes() {
        return this.nodes().filter(this::isLane);
    }

    private boolean isLane(NodeT n) {
        return ((View)n.getContent()).getDefinition() instanceof Lane;
    }
}

