/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.tasks;

import bpsim.CostParameters;
import bpsim.ElementParameters;
import bpsim.FloatingParameterType;
import bpsim.NormalDistributionType;
import bpsim.Parameter;
import bpsim.ParameterValue;
import bpsim.PoissonDistributionType;
import bpsim.ResourceParameters;
import bpsim.TimeParameters;
import bpsim.UniformDistributionType;
import org.eclipse.emf.common.util.EList;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Match;
import org.kie.workbench.common.stunner.bpmn.backend.converters.VoidMatch;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationAttributeSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;

public class Simulations {
    public static SimulationSet simulationSet(ElementParameters eleType) {
        ResourceParameters resourceParams;
        SimulationSet simulationSet = new SimulationSet();
        TimeParameters timeParams = eleType.getTimeParameters();
        if (timeParams == null) {
            return simulationSet;
        }
        Parameter processingTime = timeParams.getProcessingTime();
        ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
        VoidMatch.of(ParameterValue.class).when(NormalDistributionType.class, ndt -> {
            simulationSet.getMean().setValue(Double.valueOf(ndt.getMean()));
            simulationSet.getStandardDeviation().setValue(Double.valueOf(ndt.getStandardDeviation()));
            simulationSet.getDistributionType().setValue("normal");
        }).when(UniformDistributionType.class, udt -> {
            simulationSet.getMin().setValue(Double.valueOf(udt.getMin()));
            simulationSet.getMax().setValue(Double.valueOf(udt.getMax()));
            simulationSet.getDistributionType().setValue("uniform");
        }).when(PoissonDistributionType.class, pdt -> {
            simulationSet.getMean().setValue(Double.valueOf(pdt.getMean()));
            simulationSet.getDistributionType().setValue("poisson");
        }).apply(paramValue).asSuccess().value();
        CostParameters costParams = eleType.getCostParameters();
        if (costParams != null) {
            simulationSet.getUnitCost().setValue(Simulations.extractDouble(costParams.getUnitCost()));
        }
        if ((resourceParams = eleType.getResourceParameters()) != null) {
            Double quantity = Simulations.extractDouble(resourceParams.getQuantity());
            simulationSet.getQuantity().setValue(quantity);
            Double availability = Simulations.extractDouble(resourceParams.getAvailability());
            simulationSet.getWorkingHours().setValue(availability);
        }
        return simulationSet;
    }

    public static SimulationAttributeSet simulationAttributeSet(ElementParameters eleType) {
        SimulationAttributeSet simulationSet = new SimulationAttributeSet();
        TimeParameters timeParams = eleType.getTimeParameters();
        if (timeParams == null) {
            return simulationSet;
        }
        Parameter processingTime = timeParams.getProcessingTime();
        ParameterValue paramValue = (ParameterValue)processingTime.getParameterValue().get(0);
        return Match.of(ParameterValue.class, SimulationAttributeSet.class).when(NormalDistributionType.class, ndt -> {
            simulationSet.getMean().setValue(Double.valueOf(ndt.getMean()));
            simulationSet.getStandardDeviation().setValue(Double.valueOf(ndt.getStandardDeviation()));
            simulationSet.getDistributionType().setValue("normal");
            return simulationSet;
        }).when(UniformDistributionType.class, udt -> {
            simulationSet.getMin().setValue(Double.valueOf(udt.getMin()));
            simulationSet.getMax().setValue(Double.valueOf(udt.getMax()));
            simulationSet.getDistributionType().setValue("uniform");
            return simulationSet;
        }).when(PoissonDistributionType.class, pdt -> {
            simulationSet.getMean().setValue(Double.valueOf(pdt.getMean()));
            simulationSet.getDistributionType().setValue("poisson");
            return simulationSet;
        }).apply(paramValue).asSuccess().value();
    }

    private static Double extractDouble(Parameter parameter) {
        if (parameter == null) {
            return 0.0;
        }
        return Simulations.extractDouble((EList<ParameterValue>)parameter.getParameterValue());
    }

    private static Double extractDouble(EList<ParameterValue> parameterValues) {
        if (parameterValues.isEmpty()) {
            throw new IllegalArgumentException("failure params");
        }
        ParameterValue value = (ParameterValue)parameterValues.get(0);
        FloatingParameterType floatingValue = (FloatingParameterType)value;
        return floatingValue.getValue();
    }
}

