/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.wildfly.properties;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.msc.service.StartException;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.Capability;
import org.uberfire.ext.security.management.api.CapabilityStatus;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserManagerSettings;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.exception.InvalidEntityIdentifierException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.exception.UserNotFoundException;
import org.uberfire.ext.security.management.impl.UserManagerSettingsImpl;
import org.uberfire.ext.security.management.search.IdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.search.UsersIdentifierRuntimeSearchEngine;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;
import org.uberfire.ext.security.management.wildfly.properties.BaseWildflyPropertiesManager;
import org.uberfire.ext.security.management.wildfly.properties.PropertiesLineWriterPredicate;
import org.uberfire.ext.security.management.wildfly.properties.WildflyGroupPropertiesManager;

public class WildflyUserPropertiesManager
extends BaseWildflyPropertiesManager
implements UserManager,
ContextualManager {
    public static final String DEFAULT_USERS_FILE = "./standalone/configuration/application-users.properties";
    public static final String DEFAULT_PASSWORD = "";
    public static final String VALID_USERNAME_SYMBOLS = "\",\", \"-\", \".\", \"/\", \"=\", \"@\", \"\\\"";
    private static final Logger LOG = LoggerFactory.getLogger(WildflyUserPropertiesManager.class);
    protected final IdentifierRuntimeSearchEngine<User> usersSearchEngine = new UsersIdentifierRuntimeSearchEngine();
    protected UserSystemManager userSystemManager;
    protected String usersFilePath;
    WildflyUsersPropertiesFileLoader usersFileLoader;

    public WildflyUserPropertiesManager() {
        this(new ConfigProperties(System.getProperties()));
    }

    public WildflyUserPropertiesManager(Map<String, String> gitPrefs) {
        this(new ConfigProperties(gitPrefs));
    }

    public WildflyUserPropertiesManager(ConfigProperties gitPrefs) {
        this.loadConfig(gitPrefs);
    }

    @Override
    protected void loadConfig(ConfigProperties config) {
        LOG.debug("Configuring JBoss Wildfly provider from properties.");
        super.loadConfig(config);
        ConfigProperties.ConfigProperty usersFilePathProperty = config.get("org.uberfire.ext.security.management.wildfly.properties.users-file-path", DEFAULT_USERS_FILE);
        if (!WildflyUserPropertiesManager.isConfigPropertySet(usersFilePathProperty)) {
            throw new IllegalArgumentException("Property 'org.uberfire.ext.security.management.wildfly.properties.users-file-path' is mandatory and not set.");
        }
        this.usersFilePath = usersFilePathProperty.getValue();
        LOG.debug("Configuration of JBoss WildFly provider finished.");
    }

    public void initialize(UserSystemManager userSystemManager) throws Exception {
        this.userSystemManager = userSystemManager;
        this.getUsersFileLoader();
    }

    public void destroy() throws Exception {
        this.getUsersFileLoader().stop();
    }

    public AbstractEntityManager.SearchResponse<User> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        List<String> users = this.getUserNames();
        return this.usersSearchEngine.searchByIdentifiers(users, request);
    }

    public User get(String identifier) throws SecurityManagementException {
        this.validateUserIdentifier(identifier);
        List<String> userNames = this.getUserNames();
        if (userNames != null && userNames.contains(identifier)) {
            return this.getUser(identifier);
        }
        throw new UserNotFoundException(identifier);
    }

    public List<User> getAll() throws SecurityManagementException {
        return this.getUserNames().stream().map(this::getUser).collect(Collectors.toList());
    }

    public String getUsersFilePath() {
        return this.usersFilePath;
    }

    public User create(User entity) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"entity", (Object)entity);
        String username = entity.getIdentifier();
        try {
            if (null == username || 0 == username.trim().length()) {
                throw new IllegalArgumentException("No username specified.");
            }
            this.validateUserIdentifier(username);
            this.usersFileLoader.getProperties().put(username, DEFAULT_PASSWORD);
            this.usersFileLoader.persistProperties();
        }
        catch (IOException e) {
            LOG.error("Error creating user " + username, (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
        return entity;
    }

    public User update(User entity) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"entity", (Object)entity);
        return entity;
    }

    public void delete(String ... usernames) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"usernames", (Object)usernames);
        for (String username : usernames) {
            User user = this.get(username);
            if (user == null) {
                throw new UserNotFoundException(username);
            }
            try {
                this.usersFileLoader.getProperties().remove(username);
                this.usersFileLoader.persistProperties();
                this.getGroupsPropertiesManager().removeEntry(username);
            }
            catch (IOException e) {
                LOG.error("Error deleting user " + username, (Throwable)e);
                throw new SecurityManagementException((Throwable)e);
            }
        }
    }

    public void assignGroups(String username, Collection<String> groups) throws SecurityManagementException {
        if (this.getGroupsPropertiesManager() != null) {
            Set userRoles = SecurityManagementUtils.rolesToString((Set)SecurityManagementUtils.getRoles((UserSystemManager)this.userSystemManager, (String)username));
            userRoles.addAll(groups);
            this.getGroupsPropertiesManager().setGroupsForUser(username, userRoles);
        }
    }

    public void assignRoles(String username, Collection<String> roles) throws SecurityManagementException {
        if (this.getGroupsPropertiesManager() != null) {
            Set userGroups = SecurityManagementUtils.groupsToString((Set)SecurityManagementUtils.getGroups((UserSystemManager)this.userSystemManager, (String)username));
            userGroups.addAll(roles);
            this.getGroupsPropertiesManager().setGroupsForUser(username, userGroups);
        }
    }

    public void changePassword(String username, String newPassword) throws SecurityManagementException {
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        PortablePreconditions.checkNotNull((String)"username", (Object)username);
        if (0 == username.trim().length()) {
            throw new IllegalArgumentException("No username specified for updating password.");
        }
        try {
            this.usersFileLoader.getProperties().put(username, WildflyUserPropertiesManager.generateHashPassword(username, this.realm, newPassword));
            this.usersFileLoader.persistProperties();
        }
        catch (IOException e) {
            LOG.error("Error changing user's password", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }

    public UserManagerSettings getSettings() {
        HashMap<Capability, CapabilityStatus> capabilityStatusMap = new HashMap<Capability, CapabilityStatus>(8);
        for (Capability capability : SecurityManagementUtils.USERS_CAPABILITIES) {
            capabilityStatusMap.put(capability, this.getCapabilityStatus(capability));
        }
        return new UserManagerSettingsImpl(capabilityStatusMap, null);
    }

    private User getUser(String userName) {
        Set[] gr;
        Set userGroups = null;
        Set userRoles = null;
        if (this.getGroupsPropertiesManager() != null && null != (gr = this.getGroupsPropertiesManager().getGroupsAndRolesForUser(userName))) {
            userGroups = gr[0];
            userRoles = gr[1];
        }
        return SecurityManagementUtils.createUser((String)userName, userGroups, userRoles);
    }

    protected CapabilityStatus getCapabilityStatus(Capability capability) {
        if (capability != null) {
            switch (capability) {
                case CAN_SEARCH_USERS: 
                case CAN_ADD_USER: 
                case CAN_UPDATE_USER: 
                case CAN_DELETE_USER: 
                case CAN_READ_USER: 
                case CAN_ASSIGN_GROUPS: 
                case CAN_ASSIGN_ROLES: 
                case CAN_CHANGE_PASSWORD: {
                    return CapabilityStatus.ENABLED;
                }
            }
        }
        return CapabilityStatus.UNSUPPORTED;
    }

    protected WildflyUsersPropertiesFileLoader buildFileLoader(String usersFilePath) throws Exception {
        File usersFile = new File(usersFilePath);
        if (!usersFile.exists()) {
            throw new RuntimeException("Properties file for users not found at '" + usersFilePath + "'.");
        }
        this.usersFileLoader = new WildflyUsersPropertiesFileLoader(usersFile.getAbsolutePath());
        try {
            this.usersFileLoader.start();
        }
        catch (Exception e) {
            throw new IOException("Failed to start UserPropertiesFileLoader.", e);
        }
        return this.usersFileLoader;
    }

    protected List<String> getUserNames() {
        try {
            Properties properties = this.usersFileLoader.getProperties();
            return this.toList(properties);
        }
        catch (Exception e) {
            LOG.error("Error obtaining JBoss users from properties file.", (Throwable)e);
            throw new SecurityManagementException((Throwable)e);
        }
    }

    private List<String> toList(Properties p) {
        if (null != p && !p.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(p.size());
            Enumeration<?> pNames = p.propertyNames();
            while (pNames.hasMoreElements()) {
                String pName = (String)pNames.nextElement();
                String trimmed = pName.trim();
                if (trimmed.startsWith("#")) continue;
                result.add(pName);
            }
            return result;
        }
        return new ArrayList<String>(0);
    }

    protected WildflyUsersPropertiesFileLoader getUsersFileLoader() throws Exception {
        if (this.usersFileLoader == null) {
            this.usersFileLoader = this.buildFileLoader(this.getUsersFilePath());
        }
        return this.usersFileLoader;
    }

    protected synchronized WildflyGroupPropertiesManager getGroupsPropertiesManager() {
        try {
            return (WildflyGroupPropertiesManager)this.userSystemManager.groups();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void validateUserIdentifier(String identifier) {
        if (!PropertiesFileLoader.PROPERTY_PATTERN.matcher(identifier + "=0").matches()) {
            throw new InvalidEntityIdentifierException(identifier, VALID_USERNAME_SYMBOLS);
        }
    }

    public static final class WildflyUsersPropertiesFileLoader
    extends UserPropertiesFileLoader {
        private final PropertiesLineWriterPredicate lineWriterPredicate = new PropertiesLineWriterPredicate(arg_0 -> ((WildflyUsersPropertiesFileLoader)this).cleanKey(arg_0), true);

        public WildflyUsersPropertiesFileLoader(String path) {
            this(path, null);
        }

        public WildflyUsersPropertiesFileLoader(String path, String relativeTo) {
            super(null, path, relativeTo);
        }

        public void start() throws StartException {
            super.start(null);
        }

        public void stop() {
            super.stop(null);
        }

        protected void beginPersistence() throws IOException {
            this.lineWriterPredicate.begin(this.getProperties());
            super.beginPersistence();
        }

        protected void endPersistence(BufferedWriter writer) throws IOException {
            super.endPersistence(writer);
            this.lineWriterPredicate.end();
        }

        protected void write(BufferedWriter writer, String line, boolean newLine) throws IOException {
            if (this.lineWriterPredicate.test(line)) {
                super.write(writer, line, newLine);
            }
        }
    }
}

