/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.definition.clone.CloneManager;
import org.kie.workbench.common.stunner.core.definition.clone.ClonePolicy;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.CloneConnectorCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.RegisterNodeCommand;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.UUID;

@Portable
public class CloneNodeCommand
extends AbstractGraphCompositeCommand {
    private final Node<Definition, Edge> candidate;
    private final Optional<String> parentUuidOptional;
    private final Point2D position;
    private transient Node<View, Edge> clone;
    private transient Optional<Consumer<Node>> callbackOptional;
    private transient ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor;
    private transient List<Command<GraphCommandExecutionContext, RuleViolation>> childrenCommands;
    private static Logger LOGGER = Logger.getLogger(CloneNodeCommand.class.getName());

    protected CloneNodeCommand() {
        this(null, null, null, null, null);
    }

    public CloneNodeCommand(@MapsTo(value="candidate") Node candidate, @MapsTo(value="parentUuid") String parentUuid) {
        this((Node)PortablePreconditions.checkNotNull((String)"candidate", (Object)candidate), (String)PortablePreconditions.checkNotNull((String)"parentUuid", (Object)parentUuid), null, null, null);
    }

    public CloneNodeCommand(Node candidate, String parentUuid, Point2D position, Consumer<Node> callback, ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor) {
        this.candidate = candidate;
        this.parentUuidOptional = Optional.ofNullable(parentUuid);
        this.position = position;
        this.callbackOptional = Optional.ofNullable(callback);
        this.childrenTraverseProcessor = childrenTraverseProcessor;
    }

    public CloneNodeCommand(Node candidate, String parentUuid, Point2D position, Consumer<Node> callback) {
        this(candidate, parentUuid, position, callback, null);
    }

    @Override
    protected boolean delegateRulesContextToChildren() {
        return false;
    }

    @Override
    protected AbstractCompositeCommand<GraphCommandExecutionContext, RuleViolation> initialize(GraphCommandExecutionContext context) {
        Optional<String> parentUUID = this.getParentUUID();
        if (!parentUUID.isPresent()) {
            throw new IllegalStateException("Parent not found for node " + this.candidate);
        }
        Object bean = ((Definition)this.candidate.getContent()).getDefinition();
        DefinitionId definitionId = context.getDefinitionManager().adapters().forDefinition().getId(bean);
        this.clone = context.getFactoryManager().newElement(UUID.uuid(), definitionId.value()).asNode();
        this.cloneNodeContentWithProperties(context);
        this.createNodeCommands(this.clone, parentUUID.get(), this.position);
        return this;
    }

    protected void createNodeCommands(Node<View, Edge> clone, String parentUUID, Point2D position) {
        this.addCommand(new RegisterNodeCommand(clone));
        this.addCommand(new AddChildNodeCommand(parentUUID, clone, position));
    }

    void cloneNodeContentWithProperties(GraphCommandExecutionContext context) {
        View cloneContent = (View)this.getClone().getContent();
        View candidateContent = (View)this.getCandidate().getContent();
        Bounds candidateBounds = candidateContent.getBounds();
        Bounds clonedBounds = this.cloneBounds(candidateBounds);
        CloneManager cloneManager = context.getDefinitionManager().cloneManager();
        Object clonedDefinition = cloneManager.clone(candidateContent.getDefinition(), ClonePolicy.ALL);
        cloneContent.setBounds(clonedBounds);
        cloneContent.setDefinition(clonedDefinition);
    }

    Bounds cloneBounds(Bounds bounds) {
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        return Bounds.create((double)ul.getX(), (double)ul.getY(), (double)lr.getX(), (double)lr.getY());
    }

    @Override
    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult finalResult;
        CommandResult result = super.execute(context);
        if (CommandUtils.isError(result)) {
            return result;
        }
        ArrayList commandResults = new ArrayList();
        commandResults.add(result);
        this.childrenCommands = new LinkedList<Command<GraphCommandExecutionContext, RuleViolation>>();
        if (GraphUtils.hasChildren(this.candidate)) {
            commandResults.addAll(this.processChildrenNodes(context));
        }
        if (GraphUtils.hasDockedNodes(this.candidate)) {
            commandResults.addAll(this.processDockedNodes(context));
        }
        if (CommandUtils.isError(finalResult = this.buildResult(commandResults))) {
            this.processMultipleFunctions(this.childrenCommands, c -> this.doUndo(context, (Command<GraphCommandExecutionContext, RuleViolation>)c), reverted -> {});
            this.processMultipleFunctions(this.getCommands(), c -> this.doUndo(context, (Command<GraphCommandExecutionContext, RuleViolation>)c), reverted -> {});
            return finalResult;
        }
        this.callbackOptional.ifPresent(callback -> callback.accept(this.clone));
        LOGGER.info("Node " + this.candidate.getUUID() + "was cloned successfully to " + this.clone.getUUID());
        return finalResult;
    }

    public List<CommandResult<RuleViolation>> processChildrenNodes(final GraphCommandExecutionContext context) {
        final ArrayList<CommandResult<RuleViolation>> commandResults = new ArrayList<CommandResult<RuleViolation>>();
        final HashMap cloneNodeMapUUID = new HashMap();
        Graph graph = context.getGraphIndex().getGraph();
        ((ChildrenTraverseProcessor)this.childrenTraverseProcessor.get()).setRootUUID(this.candidate.getUUID()).traverse((Object)graph, (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

            @Override
            public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> node) {
                CloneNodeCommand command = CloneNodeCommand.this.createCloneChildCommand(node, CloneNodeCommand.this.clone.getUUID(), GraphUtils.getPosition((View)node.getContent()), childClone -> cloneNodeMapUUID.put(node.getUUID(), childClone), (ManagedInstance<ChildrenTraverseProcessor>)CloneNodeCommand.this.childrenTraverseProcessor);
                CloneNodeCommand.this.childrenCommands.add(command);
                commandResults.add(command.execute(context));
                return false;
            }
        });
        commandResults.addAll(cloneNodeMapUUID.keySet().stream().flatMap(sourceUUID -> this.getNode(context, (String)sourceUUID).getOutEdges().stream()).filter(edge -> edge.getContent() instanceof ViewConnector).filter(edge -> Objects.nonNull(edge.getSourceNode()) && Objects.nonNull(edge.getTargetNode())).map(edge -> {
            Node candidateToClone = (Node)cloneNodeMapUUID.get(edge.getTargetNode().getUUID());
            Node parentToClone = (Node)cloneNodeMapUUID.get(edge.getSourceNode().getUUID());
            if (Objects.isNull(candidateToClone) || Objects.isNull(parentToClone)) {
                return null;
            }
            Object command = edge.getContent() instanceof Dock ? new DockNodeCommand(parentToClone, candidateToClone) : new CloneConnectorCommand((Edge)edge, parentToClone.getUUID(), candidateToClone.getUUID());
            this.childrenCommands.add((Command<GraphCommandExecutionContext, RuleViolation>)command);
            return command;
        }).filter(Objects::nonNull).map(command -> command.execute((Object)context)).collect(Collectors.toList()));
        return commandResults;
    }

    protected CloneNodeCommand createCloneChildCommand(Node candidate, String parentUuid, Point2D position, Consumer<Node> callback, ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor) {
        return new CloneNodeCommand(candidate, parentUuid, position, callback, childrenTraverseProcessor);
    }

    private List<CommandResult<RuleViolation>> processDockedNodes(GraphCommandExecutionContext context) {
        return this.candidate.getOutEdges().stream().filter(edge -> edge.getContent() instanceof Dock).map(edge -> edge.getTargetNode()).filter(node -> node.getContent() instanceof View).map(targetNode -> {
            CloneNodeCommand command = new CloneNodeCommand((Node)targetNode, this.parentUuidOptional.get(), GraphUtils.getPosition((View)targetNode.getContent()), cloneDock -> new DockNodeCommand(this.clone, (Node<?, Edge>)cloneDock).execute(context), this.childrenTraverseProcessor);
            this.childrenCommands.add(command);
            return command;
        }).map(command -> command.execute(context)).collect(Collectors.toList());
    }

    private Optional<String> getParentUUID() {
        return this.parentUuidOptional.isPresent() ? this.parentUuidOptional : this.getDefaultParent();
    }

    private Optional<String> getDefaultParent() {
        Optional<Element<?>> parent = Optional.ofNullable(GraphUtils.getParent(this.candidate));
        if (parent.isPresent()) {
            return Optional.of(parent.get().getUUID());
        }
        return Optional.empty();
    }

    @Override
    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        return new SafeDeleteNodeCommand(this.clone).execute(context);
    }

    public Node<View, Edge> getClone() {
        return this.clone;
    }

    void setClone(Node<View, Edge> clone) {
        this.clone = clone;
    }

    public Node<Definition, Edge> getCandidate() {
        return this.candidate;
    }

    public List<Command<GraphCommandExecutionContext, RuleViolation>> getChildrenCommands() {
        return this.childrenCommands;
    }
}

