/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Collection;
import java.util.Optional;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.context.CardinalityContext;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext;

@Portable
public class SetConnectionTargetNodeCommand
extends AbstractGraphCommand {
    private final String targetNodeUUID;
    private final String edgeUUID;
    private final Connection connection;
    Connection lastConnection;
    private String lastTargetNodeUUID;
    private transient Edge<? extends View, Node> edge;
    private transient Node<? extends View<?>, Edge> sourceNode;
    private transient Node<? extends View<?>, Edge> targetNode;

    public SetConnectionTargetNodeCommand(@MapsTo(value="targetNodeUUID") String targetNodeUUID, @MapsTo(value="edgeUUID") String edgeUUID, @MapsTo(value="magnet") Connection connection) {
        this.edgeUUID = (String)PortablePreconditions.checkNotNull((String)"edgeUUID", (Object)edgeUUID);
        this.targetNodeUUID = targetNodeUUID;
        this.connection = connection;
        this.lastTargetNodeUUID = null;
        this.lastConnection = null;
    }

    public SetConnectionTargetNodeCommand(Node<? extends View<?>, Edge> targetNode, Edge<? extends View, Node> edge, Connection connection) {
        this(null != targetNode ? targetNode.getUUID() : null, edge.getUUID(), connection);
        this.edge = (Edge)PortablePreconditions.checkNotNull((String)"edge", edge);
        this.sourceNode = edge.getSourceNode();
        this.targetNode = targetNode;
    }

    public SetConnectionTargetNodeCommand(Node<? extends View<?>, Edge> targetNode, Edge<? extends View, Node> edge) {
        this(targetNode, edge, null);
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        CommandResult<RuleViolation> results = this.allow(context);
        if (!results.getType().equals((Object)CommandResult.Type.ERROR)) {
            Edge<? extends View, Node> edge = this.getEdge(context);
            Node<? extends View<?>, Edge> targetNode = this.getTargetNode(context);
            Node lastTargetNode = edge.getTargetNode();
            if (null != lastTargetNode) {
                this.lastTargetNodeUUID = lastTargetNode.getUUID();
                lastTargetNode.getInEdges().remove(edge);
            }
            if (null != targetNode) {
                targetNode.getInEdges().add(edge);
            }
            edge.setTargetNode(targetNode);
            ViewConnector connectionContent = (ViewConnector)edge.getContent();
            this.lastConnection = connectionContent.getTargetConnection().orElse(null);
            connectionContent.setTargetConnection(this.connection);
        }
        return results;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        GraphCommandResultBuilder resultBuilder = new GraphCommandResultBuilder();
        Node<? extends View<?>, Edge> targetNode = this.getTargetNode(context);
        Edge<? extends View, Node> edge = this.getEdge(context);
        Node lastTargetNode = edge.getTargetNode();
        if (null == lastTargetNode && null != targetNode || null != lastTargetNode && !lastTargetNode.equals(targetNode)) {
            Collection<RuleViolation> cardinalityRuleViolations;
            Collection<RuleViolation> connectionRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.connection(edge, Optional.ofNullable(this.sourceNode), Optional.ofNullable(targetNode)));
            resultBuilder.addViolations(connectionRuleViolations);
            Node currentTarget = edge.getTargetNode();
            if (null != currentTarget) {
                cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.edgeCardinality((Element<? extends View<?>>)currentTarget, (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.INCOMING, Optional.of(CardinalityContext.Operation.DELETE)));
                resultBuilder.addViolations(cardinalityRuleViolations);
            }
            if (null != targetNode) {
                cardinalityRuleViolations = this.evaluate(context, contextBuilder -> contextBuilder.edgeCardinality((Element<? extends View<?>>)targetNode, (Edge<? extends View<?>, Node>)edge, EdgeCardinalityContext.Direction.INCOMING, Optional.of(CardinalityContext.Operation.ADD)));
                resultBuilder.addViolations(cardinalityRuleViolations);
            }
        }
        return resultBuilder.build();
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        SetConnectionTargetNodeCommand undoCommand = new SetConnectionTargetNodeCommand(this.getNode(context, this.lastTargetNodeUUID), this.getEdge(context), this.lastConnection);
        return undoCommand.execute(context);
    }

    protected Edge<? extends View, Node> getEdge(GraphCommandExecutionContext context) {
        if (null == this.edge) {
            this.edge = this.getViewEdge(context, this.edgeUUID);
        }
        return this.edge;
    }

    private Node<? extends View<?>, Edge> getSourceNode(GraphCommandExecutionContext context) {
        if (null == this.sourceNode) {
            this.sourceNode = this.getEdge(context).getSourceNode();
        }
        return this.sourceNode;
    }

    protected Node<? extends View<?>, Edge> getTargetNode(GraphCommandExecutionContext context) {
        if (null == this.targetNode) {
            this.targetNode = this.getNode(context, this.targetNodeUUID);
        }
        return this.targetNode;
    }

    public Edge<? extends View, Node> getEdge() {
        return this.edge;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Node<? extends View<?>, Edge> getTargetNode() {
        return this.targetNode;
    }

    public Node<? extends View<?>, Edge> getSourceNode() {
        return this.sourceNode;
    }

    public String getTargetNodeUUID() {
        return this.targetNodeUUID;
    }

    public Connection getLastConnection() {
        return this.lastConnection;
    }

    public String getLastTargetNodeUUID() {
        return this.lastTargetNodeUUID;
    }

    public String toString() {
        return "SetConnectionTargetNodeCommand [edge=" + this.edgeUUID + ", candidate=" + (null != this.targetNodeUUID ? this.targetNodeUUID : "null") + ", magnet=" + this.connection + "]";
    }
}

