/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.processing.traverse.content;

import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ContentTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ContentTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

public abstract class AbstractContentTraverseProcessor<C, N extends Node<View, Edge>, E extends Edge<C, Node>, K extends ContentTraverseCallback<C, N, E>>
implements ContentTraverseProcessor<C, N, E, K> {
    TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    @Inject
    public AbstractContentTraverseProcessor(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    protected boolean doStartEdgeTraversal(Edge edge, K callback) {
        if (this.accepts(edge)) {
            callback.startEdgeTraversal(edge);
            return true;
        }
        return false;
    }

    protected boolean doEndEdgeTraversal(Edge edge, K callback) {
        if (this.accepts(edge)) {
            callback.endEdgeTraversal(edge);
            return true;
        }
        return false;
    }

    protected boolean accepts(Edge edge) {
        return true;
    }

    protected void doStartGraphTraversal(Graph graph, K callback) {
        if (graph.getContent() instanceof View) {
            callback.startGraphTraversal(graph);
        }
    }

    protected boolean doStartNodeTraversal(Node node, K callback) {
        if (node.getContent() instanceof View) {
            callback.startNodeTraversal(node);
            return true;
        }
        return false;
    }

    protected void doEndNodeTraversal(Node node, K callback) {
        if (node.getContent() instanceof View) {
            callback.endNodeTraversal(node);
        }
    }

    protected void doEndGraphTraversal(Graph graph, K callback) {
        callback.endGraphTraversal();
    }

    public void traverse(final Graph<View, N> graph, final K callback) {
        this.treeWalkTraverseProcessor.traverse(graph, (Object)new TreeTraverseCallback<Graph, Node, Edge>(){

            public void startGraphTraversal(Graph graph2) {
                AbstractContentTraverseProcessor.this.doStartGraphTraversal(graph2, callback);
            }

            public boolean startNodeTraversal(Node node) {
                return AbstractContentTraverseProcessor.this.doStartNodeTraversal(node, callback);
            }

            public boolean startEdgeTraversal(Edge edge) {
                return AbstractContentTraverseProcessor.this.doStartEdgeTraversal(edge, callback);
            }

            public void endNodeTraversal(Node node) {
                AbstractContentTraverseProcessor.this.doEndNodeTraversal(node, callback);
            }

            public void endEdgeTraversal(Edge edge) {
                AbstractContentTraverseProcessor.this.doEndEdgeTraversal(edge, callback);
            }

            public void endGraphTraversal() {
                AbstractContentTraverseProcessor.this.doEndGraphTraversal(graph, callback);
            }
        });
    }
}

