/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.session;

import javax.inject.Inject;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.guvnor.common.services.project.model.Module;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.session.SessionService;
import org.kie.workbench.common.services.shared.project.KieModule;

public class SessionServiceImpl
implements SessionService {
    private BuildInfoService buildInfoService;

    public SessionServiceImpl() {
    }

    @Inject
    public SessionServiceImpl(BuildInfoService buildInfoService) {
        this.buildInfoService = buildInfoService;
    }

    public KieSession newKieSession(KieModule project, String ksessionName) {
        KieContainer kieContainer = this.buildInfoService.getBuildInfo((Module)project).getKieContainer();
        if (kieContainer == null) {
            return null;
        }
        return kieContainer.newKieSession(ksessionName);
    }

    public KieSession newDefaultKieSessionWithPseudoClock(KieModule project) {
        KieContainer kieContainer = this.buildInfoService.getBuildInfo((Module)project).getKieContainer();
        if (kieContainer == null) {
            return null;
        }
        SessionConfiguration conf = SessionConfiguration.newInstance();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        return kieContainer.getKieBase().newKieSession((KieSessionConfiguration)conf, null);
    }
}

