/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.util;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.DataObject;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class DataObjectUtils {
    private static boolean isBPMNDefinition(Node node) {
        return node.getContent() instanceof View && ((View)node.getContent()).getDefinition() instanceof BPMNDefinition;
    }

    public static Set<DataObject> findDataObjects(ClientSession session, GraphUtils graphUtils, Node selectedElement, Set<String> parentIds) {
        Iterable nodes = session.getCanvasHandler().getDiagram().getGraph().nodes();
        return StreamSupport.stream(nodes.spliterator(), false).filter(DataObjectUtils::isBPMNDefinition).map(elm -> elm).filter(elm -> {
            if (((View)elm.getContent()).getDefinition() instanceof DataObject) {
                Element parent = GraphUtils.getParent((Node)elm);
                if (parent == null) {
                    return true;
                }
                return parentIds.contains(parent.getUUID());
            }
            return false;
        }).map(elm -> (DataObject)((View)elm.getContent()).getDefinition()).collect(Collectors.toSet());
    }
}

