/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AssociationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.DirectionalAssociation;
import org.kie.workbench.common.stunner.bpmn.definition.NonDirectionalAssociation;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AssociationPropertyReaderTest {
    private static String SOURCE_ID = "SOURCE_ID";
    private static String TARGET_ID = "TARGET_ID";
    private static String ASSOCIATION_ID = "ASSOCIATION_ID";
    private static double X = 1.0;
    private static double Y = 2.0;
    @Mock
    private DefinitionResolver definitionResolver;
    @Mock
    private Association association;
    @Mock
    private BaseElement sourceRef;
    @Mock
    private BaseElement targetRef;
    @Mock
    private BPMNDiagram bpmnDiagram;
    @Mock
    private BPMNPlane bpmnLane;
    private Point2D position;
    @Mock
    private AssociationPropertyReader propertyReader;

    @Before
    public void setUp() {
        this.position = Point2D.create((double)X, (double)Y);
        Mockito.when((Object)this.bpmnDiagram.getPlane()).thenReturn((Object)this.bpmnLane);
        Mockito.when((Object)this.association.getId()).thenReturn((Object)ASSOCIATION_ID);
        Mockito.when((Object)this.sourceRef.getId()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.targetRef.getId()).thenReturn((Object)TARGET_ID);
        Mockito.when((Object)this.association.getSourceRef()).thenReturn((Object)this.sourceRef);
        Mockito.when((Object)this.association.getTargetRef()).thenReturn((Object)this.targetRef);
        this.propertyReader = new AssociationPropertyReader(this.association, this.bpmnDiagram, this.definitionResolver);
    }

    @Test
    public void testGetSourceId() {
        Assert.assertEquals((Object)SOURCE_ID, (Object)this.propertyReader.getSourceId());
    }

    @Test
    public void testGetTargetId() {
        Assert.assertEquals((Object)TARGET_ID, (Object)this.propertyReader.getTargetId());
    }

    @Test
    public void testGetAssociationByDirection() {
        Association association = Bpmn2Factory.eINSTANCE.createAssociation();
        association.setAssociationDirection(null);
        this.propertyReader = new AssociationPropertyReader(association, this.bpmnDiagram, this.definitionResolver);
        Assert.assertEquals(NonDirectionalAssociation.class, (Object)this.propertyReader.getAssociationByDirection());
        association.setAssociationDirection(AssociationDirection.NONE);
        Assert.assertEquals(NonDirectionalAssociation.class, (Object)this.propertyReader.getAssociationByDirection());
        association.setAssociationDirection(AssociationDirection.ONE);
        Assert.assertEquals(DirectionalAssociation.class, (Object)this.propertyReader.getAssociationByDirection());
    }
}

