/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.process.workitem.WorkDefinitionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionRemoteRequest;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionRemoteService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkItemDefinitionRemoteServiceTest {
    private static final String URL = "http://url";
    private static final String WD1_NAME = "wd1Name";
    private static final String WD2_NAME = "wd2Name";
    @Mock
    private Function<String, WorkItemDefinitionRemoteService.WorkItemsHolder> lookupService;
    private WorkItemDefinitionRemoteService tested;
    private WorkDefinitionImpl wd1;
    private WorkDefinitionImpl wd2;

    @Before
    public void init() {
        this.wd1 = new WorkDefinitionImpl();
        this.wd1.setName(WD1_NAME);
        this.wd2 = new WorkDefinitionImpl();
        this.wd2.setName(WD2_NAME);
        Mockito.when((Object)this.lookupService.apply((String)ArgumentMatchers.eq((Object)URL))).thenReturn((Object)new WorkItemDefinitionRemoteService.WorkItemsHolder((Map)new HashMap<String, WorkDefinitionImpl>(2){
            {
                this.put(WorkItemDefinitionRemoteServiceTest.WD1_NAME, WorkItemDefinitionRemoteServiceTest.this.wd1);
                this.put(WorkItemDefinitionRemoteServiceTest.WD2_NAME, WorkItemDefinitionRemoteServiceTest.this.wd2);
            }
        }));
        this.tested = new WorkItemDefinitionRemoteService(this.lookupService);
    }

    @Test
    public void testExecute() {
        Collection result = this.tested.execute(WorkItemDefinitionRemoteRequest.build((String)URL, (String[])new String[]{WD1_NAME, WD2_NAME}));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.stream().anyMatch(w -> WD1_NAME.equals(w.getName())));
        Assert.assertTrue((boolean)result.stream().anyMatch(w -> WD2_NAME.equals(w.getName())));
    }

    @Test
    public void testExecuteFiltered1() {
        Collection result = this.tested.execute(WorkItemDefinitionRemoteRequest.build((String)URL, (String[])new String[]{WD1_NAME}));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.stream().anyMatch(w -> WD1_NAME.equals(w.getName())));
    }

    @Test
    public void testExecuteFiltered2() {
        Collection result = this.tested.execute(WorkItemDefinitionRemoteRequest.build((String)URL, (String[])new String[]{WD2_NAME}));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.stream().anyMatch(w -> WD2_NAME.equals(w.getName())));
    }
}

