/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLFromServiceUtil {
    public static Logger logger = LoggerFactory.getLogger(URLFromServiceUtil.class);
    public static final String DEFAULT_PROTO = "tcp";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    public static String resolveHostFromEnvVarOrSystemProperty(String serviceName) {
        return URLFromServiceUtil.getEnvVarOrSystemProperty(URLFromServiceUtil.toServiceHostEnvironmentVariable(serviceName), "");
    }

    private static String getEnvVarOrSystemProperty(String envVarName, String defaultValue) {
        String answer = null;
        try {
            answer = System.getenv(envVarName);
        }
        catch (Exception e) {
            logger.warn("Failed to look up environment variable $" + envVarName + ". " + e, (Throwable)e);
        }
        if (answer == null || answer.isEmpty()) {
            answer = System.getProperty(envVarName, defaultValue);
        }
        if (!answer.isEmpty()) {
            return answer;
        }
        return defaultValue;
    }

    public static String resolveProtocolFromEnvVarOrSystemProperty(String serviceName, String servicePort) {
        return URLFromServiceUtil.getEnvVarOrSystemProperty(URLFromServiceUtil.toEnvVariable(serviceName + PORT_SUFFIX + "_" + servicePort + PROTO_SUFFIX), DEFAULT_PROTO);
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = URLFromServiceUtil.getOrCreateMetadata(entity);
        LinkedHashMap answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static String resolvePortFromEnvVarOrSystemProperty(String serviceName, String portName) {
        String envVarName = URLFromServiceUtil.toServicePortEnvironmentVariable(serviceName, portName);
        return URLFromServiceUtil.getEnvVarOrSystemProperty(envVarName, "");
    }

    public static String toServicePortEnvironmentVariable(String serviceName, String portName) {
        String name = serviceName + PORT_SUFFIX + (portName.isEmpty() ? "_" + portName : "");
        return URLFromServiceUtil.toEnvVariable(name);
    }

    private static String toServiceHostEnvironmentVariable(String serviceName) {
        return URLFromServiceUtil.toEnvVariable(serviceName + HOST_SUFFIX);
    }

    public static String toEnvVariable(String serviceName) {
        return serviceName.toUpperCase().replaceAll("-", "_");
    }

    public static String getURLFromIngressList(List<Ingress> ingressList, String namespace, String serviceName, ServicePort port) {
        for (Ingress item : ingressList) {
            String ns = URLFromServiceUtil.getNamespace((HasMetadata)item);
            if (!Objects.equals(ns, namespace) || item.getSpec() == null) continue;
            return URLFromServiceUtil.getURLFromIngressSpec(item.getSpec(), serviceName, port);
        }
        return null;
    }

    public static String getURLFromIngressSpec(IngressSpec spec, String serviceName, ServicePort port) {
        List ingressRules = spec.getRules();
        if (ingressRules != null && !ingressRules.isEmpty()) {
            for (IngressRule rule : ingressRules) {
                HTTPIngressRuleValue http = rule.getHttp();
                if (http == null || http.getPaths() == null) continue;
                return URLFromServiceUtil.getURLFromIngressRules(http.getPaths(), spec, serviceName, port, rule);
            }
        }
        return null;
    }

    public static String getURLFromIngressRules(List<HTTPIngressPath> paths, IngressSpec spec, String serviceName, ServicePort port, IngressRule rule) {
        for (HTTPIngressPath path : paths) {
            String backendServiceName;
            IngressBackend backend = path.getBackend();
            if (backend == null || !serviceName.equals(backendServiceName = backend.getServiceName()) || !URLFromServiceUtil.portsMatch(port, backend.getServicePort())) continue;
            String pathPostFix = path.getPath();
            if (spec.getTls() != null) {
                return URLFromServiceUtil.getURLFromTLSHost(rule, pathPostFix);
            }
            String answer = rule.getHost();
            if (answer == null || answer.isEmpty()) continue;
            pathPostFix = URLFromServiceUtil.fixPathPostFixIfEmpty(pathPostFix);
            return "http://" + URLUtils.pathJoin(answer, pathPostFix);
        }
        return null;
    }

    public static String getURLFromTLSHost(IngressRule rule, String pathPostFix) {
        String host = rule.getHost();
        if (!host.isEmpty()) {
            pathPostFix = URLFromServiceUtil.fixPathPostFixIfEmpty(pathPostFix);
            return "https://" + URLUtils.pathJoin(host, pathPostFix);
        }
        return null;
    }

    private static String fixPathPostFixIfEmpty(String pathPostFix) {
        return pathPostFix.isEmpty() ? "/" : pathPostFix;
    }

    private static boolean portsMatch(ServicePort servicePort, IntOrString intOrString) {
        if (intOrString != null) {
            Integer port = servicePort.getPort();
            Integer intVal = intOrString.getIntVal();
            String strVal = intOrString.getStrVal();
            if (intVal != null) {
                if (port != null) {
                    return port.intValue() == intVal.intValue();
                }
            } else if (strVal != null) {
                return strVal.equals(servicePort.getName());
            }
        }
        return false;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return entity.getMetadata() != null ? entity.getMetadata().getNamespace() : null;
        }
        return null;
    }

    public static ServicePort getServicePortByName(Service service, String portName) {
        if (portName.isEmpty()) {
            return (ServicePort)service.getSpec().getPorts().iterator().next();
        }
        for (ServicePort servicePort : service.getSpec().getPorts()) {
            if (!Objects.equals(servicePort.getName(), portName)) continue;
            return servicePort;
        }
        return null;
    }
}

