/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.Annotation;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.soup.project.datamodel.oracle.TypeSource;
import org.kie.workbench.common.forms.data.modeller.model.DataObjectFormModel;
import org.kie.workbench.common.forms.data.modeller.model.Source;
import org.kie.workbench.common.forms.data.modeller.service.impl.ext.util.ModelReaderUtil;
import org.kie.workbench.common.forms.model.MetaDataEntry;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.model.TypeInfo;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;
import org.kie.workbench.common.forms.model.impl.meta.entries.FieldLabelEntry;
import org.kie.workbench.common.forms.model.impl.meta.entries.FieldPlaceHolderEntry;
import org.kie.workbench.common.forms.model.util.formModel.FormModelPropertiesUtil;
import org.kie.workbench.common.services.datamodel.util.SortHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMOModelResolver {
    private static final Logger logger = LoggerFactory.getLogger(DMOModelResolver.class);

    public static DataObjectFormModel resolveModelForType(ModuleDataModelOracle oracle, String modelType) {
        return DMOModelResolver.resolveModelForType(oracle, modelType, DMOModelResolver::allSourceTypes);
    }

    private static DataObjectFormModel resolveModelForType(ModuleDataModelOracle oracle, String modelType, Predicate<TypeSource> sourcePredicate) {
        PortablePreconditions.checkNotNull((String)"oracle", (Object)oracle);
        PortablePreconditions.checkNotNull((String)"modelType", (Object)modelType);
        PortablePreconditions.checkNotNull((String)"sourcePredicate", sourcePredicate);
        if (FormModelPropertiesUtil.isBaseType((String)modelType)) {
            throw new IllegalArgumentException("Cannot extract FormModel for type '" + modelType + "'.");
        }
        String modelName = modelType.substring(modelType.lastIndexOf(".") + 1);
        DataObjectFormModel formModel = new DataObjectFormModel(modelName, modelType);
        TypeSource typeSource = (TypeSource)oracle.getModuleTypeSources().get(modelType);
        if (typeSource == null || !sourcePredicate.test(typeSource)) {
            return null;
        }
        if (typeSource.equals((Object)TypeSource.JAVA_DEPENDENCY)) {
            formModel.setSource(Source.EXTERNAL);
        }
        ModelField[] fields = (ModelField[])oracle.getModuleModelFields().get(modelType);
        Map fieldAnnotations = oracle.getModuleTypeFieldsAnnotations().getOrDefault(modelType, Collections.emptyMap());
        Arrays.stream(fields).forEach(modelField -> {
            if (modelField.getName().equals("this")) {
                return;
            }
            if (!FieldAccessorsAndMutators.BOTH.equals((Object)modelField.getAccessorsAndMutators())) {
                return;
            }
            Set annotations = Optional.ofNullable(fieldAnnotations.get(modelField.getName())).orElse(Collections.EMPTY_SET);
            if (!DMOModelResolver.isValidModelProperty(modelField, annotations)) {
                return;
            }
            try {
                String fieldType = modelField.getClassName();
                boolean isEnum = oracle.getModuleJavaEnumDefinitions().get(modelType + "#" + modelField.getName()) != null;
                boolean isList = "Collection".equals(modelField.getType());
                if (isList) {
                    fieldType = (String)oracle.getModuleFieldParametersType().get(modelType + "#" + modelField.getName());
                }
                TypeKind typeKind = isEnum ? TypeKind.ENUM : (FormModelPropertiesUtil.isBaseType((String)fieldType) ? TypeKind.BASE : TypeKind.OBJECT);
                TypeInfoImpl info = new TypeInfoImpl(typeKind, fieldType, isList);
                ModelPropertyImpl modelProperty = new ModelPropertyImpl(modelField.getName(), (TypeInfo)info);
                annotations.stream().filter(annotation -> annotation.getQualifiedTypeName().equalsIgnoreCase("org.kie.api.definition.type.Label")).findAny().ifPresent(arg_0 -> DMOModelResolver.lambda$null$1((ModelProperty)modelProperty, arg_0));
                formModel.addProperty((ModelProperty)modelProperty);
            }
            catch (Exception ex) {
                logger.warn("Error processing model '" + modelType + "' impossible generate FieldDefinition for model field '" + modelField.getName() + "' (" + modelField.getType() + ")");
            }
        });
        return formModel;
    }

    private static DataObjectFormModel secureResolveModelForType(ModuleDataModelOracle oracle, String typeName, Predicate<TypeSource> sourcePredicate) {
        try {
            return DMOModelResolver.resolveModelForType(oracle, typeName, sourcePredicate);
        }
        catch (Exception ex) {
            logger.warn("Impossible to extract model for type '{}': ", (Object)typeName, (Object)ex);
            return null;
        }
    }

    public static Collection<DataObjectFormModel> resolveAllFormModels(ModuleDataModelOracle oracle) {
        return DMOModelResolver.resolveModels(oracle, DMOModelResolver::allSourceTypes);
    }

    public static Collection<DataObjectFormModel> resolveModuleFormModels(ModuleDataModelOracle oracle) {
        return DMOModelResolver.resolveModels(oracle, DMOModelResolver::onlyProjectSourceTypes);
    }

    private static Collection<DataObjectFormModel> resolveModels(ModuleDataModelOracle oracle, Predicate<TypeSource> sourcePredicate) {
        return DMOModelResolver.getFactTypes(oracle).stream().map(typeName -> DMOModelResolver.secureResolveModelForType(oracle, typeName, sourcePredicate)).filter(Objects::nonNull).sorted(DMOModelResolver::compare).collect(Collectors.toList());
    }

    private static boolean allSourceTypes(TypeSource source) {
        return true;
    }

    public static Collection<String> getFactTypes(ModuleDataModelOracle oracle) {
        List packageNames = oracle.getModulePackageNames();
        return oracle.getModuleModelFields().keySet().stream().filter(factType -> DMOModelResolver.isValid(factType, packageNames)).sorted(SortHelper.ALPHABETICAL_ORDER_COMPARATOR).collect(Collectors.toList());
    }

    private static boolean isValid(String factType, Collection<String> oraclePackages) {
        int index = factType.lastIndexOf(46);
        if (index < 0) {
            return true;
        }
        String factPackage = factType.substring(0, index);
        return oraclePackages.contains(factPackage);
    }

    private static boolean onlyProjectSourceTypes(TypeSource source) {
        return TypeSource.JAVA_PROJECT.equals((Object)source);
    }

    private static int compare(DataObjectFormModel o1, DataObjectFormModel o2) {
        if (!o1.getSource().equals((Object)o2.getSource())) {
            if (o1.getSource().equals((Object)Source.INTERNAL)) {
                return -1;
            }
            return 1;
        }
        return o1.getClassName().compareTo(o2.getClassName());
    }

    public static boolean isValidModelProperty(ModelField property, Set<Annotation> annotations) {
        if (!ModelReaderUtil.isPropertyAllowed(property.getName())) {
            return false;
        }
        return annotations.stream().map(Annotation::getQualifiedTypeName).noneMatch(((Predicate<String>)ModelReaderUtil::isAnnotationAllowed).negate());
    }

    private static /* synthetic */ void lambda$null$1(ModelProperty modelProperty, Annotation annotation) {
        String label = (String)annotation.getParameters().get("value");
        modelProperty.getMetaData().addEntry((MetaDataEntry)new FieldLabelEntry(label));
        modelProperty.getMetaData().addEntry((MetaDataEntry)new FieldPlaceHolderEntry(label));
    }
}

