/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Portable
public final class UpdateElementPropertyValueCommand
extends AbstractGraphCommand {
    private final String elementUUID;
    private final String field;
    private final Object value;
    private Object oldValue;
    private transient Element<?> element;

    public UpdateElementPropertyValueCommand(@MapsTo(value="elementUUID") String elementUUID, @MapsTo(value="field") String field, @MapsTo(value="value") Object value) {
        this.elementUUID = (String)PortablePreconditions.checkNotNull((String)"elementUUID", (Object)elementUUID);
        this.field = (String)PortablePreconditions.checkNotNull((String)"field", (Object)field);
        this.value = value;
        this.element = null;
    }

    public UpdateElementPropertyValueCommand(Element<?> element, String propertyId, Object value) {
        this(element.getUUID(), propertyId, value);
        this.element = element;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        this.getNullSafeElement(context);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        Element element = this.getNullSafeElement(context);
        Object p = context.getDefinitionManager().adapters().forDefinition().getProperty(((Definition)element.getContent()).getDefinition(), this.field).get();
        PropertyAdapter adapter = context.getDefinitionManager().adapters().registry().getPropertyAdapter(p.getClass());
        this.oldValue = adapter.getValue(p);
        adapter.setValue(p, this.value);
        return GraphCommandResultBuilder.SUCCESS;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        UpdateElementPropertyValueCommand undoCommand = new UpdateElementPropertyValueCommand(this.getNullSafeElement(context), this.field, this.oldValue);
        return undoCommand.execute(context);
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public Element<?> getElement() {
        return this.element;
    }

    private Element getNullSafeElement(GraphCommandExecutionContext context) {
        if (null == this.element) {
            return super.getElementNotNull(context, this.elementUUID);
        }
        return this.element;
    }

    public String toString() {
        return "UpdateElementPropertyValueCommand [element=" + this.elementUUID + ", field=" + this.field + ", value=" + this.value + "]";
    }
}

