/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandlerCmdCallback;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="KafkaWorkItem.wid", name="KafkaPublishMessages", displayName="KafkaPublishMessages", defaultHandler="mvel: new org.jbpm.process.workitem.kafka.KafkaWorkItemHandler(\"bootstrapServers\", \"clientId\", \"keySerializerClass\", \"valueSerializerClass\")", documentation="kafka-workitem/index.html", category="kafka-workitem", icon="KafkaPublishMessages.png", parameters={@WidParameter(name="Topic", required=true), @WidParameter(name="Key", required=true), @WidParameter(name="Value", required=true)}, results={@WidResult(name="Result")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="kafka-workitem", version="7.56.0.Final")}, serviceInfo=@WidService(category="Kafka", description="publish kafka messages from a process", keywords="kafka,publish,message,topic", action=@WidAction(title="Publish message to a kafka topic"), authinfo=@WidAuth(required=true, params={"bootstrapServers", "clientId", "keySerializerClass", "valueSerializerClass"}, paramsdescription={"Bootstrap Servers", "Client ID", "Key Serializer class", "Value Serializer class"}, referencesite="https://red.ht/kafka-wih-params")))
public class KafkaWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler
implements Cacheable {
    private static String DEFAULT_HOST = "localhost:9092";
    private static String DEFAULT_KAFKA_CLIENT_ID = "jBPM-Kafka-PublishMessage";
    private static String DEFAULT_SERIALIZER = "org.apache.kafka.common.serialization.StringSerializer";
    private static String PROPERTY_PREFIX = "org.jbpm.process.workitem.kafka.";
    private static String GLOBAL_RECONNECT_BACKOFF_MAX_MS = PROPERTY_PREFIX + "reconnect.backoff.max.ms";
    private static String GLOBAL_RECONNECT_BACKOFF_MS = PROPERTY_PREFIX + "reconnect.backoff.ms";
    private static String GLOBAL_REQUEST_TIMEOUT_MS = PROPERTY_PREFIX + "request.timeout.ms";
    private static String GLOBAL_RETRIES = PROPERTY_PREFIX + "retries";
    private static String GLOBAL_RETRY_BACKOFF_MS = PROPERTY_PREFIX + "retry.backoff.ms";
    private static String GLOBAL_ENABLE_IDEMPOTENCE = PROPERTY_PREFIX + "enable.idempotence";
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWorkItemHandler.class);
    private static Map<Properties, Producer> producers = new ConcurrentHashMap<Properties, Producer>();
    private ExecutorService executorService;
    private Properties properties;
    private static final String RESULTS_VALUE = "Result";

    public KafkaWorkItemHandler(Properties properties, Producer producer) {
        this.properties = properties;
        producers.put(properties, producer);
    }

    public KafkaWorkItemHandler() {
        this(DEFAULT_HOST, DEFAULT_KAFKA_CLIENT_ID, DEFAULT_SERIALIZER, DEFAULT_SERIALIZER);
    }

    public KafkaWorkItemHandler(ClassLoader classLoader) {
        this(DEFAULT_HOST, DEFAULT_KAFKA_CLIENT_ID, DEFAULT_SERIALIZER, DEFAULT_SERIALIZER, classLoader);
    }

    public KafkaWorkItemHandler(ClassLoader classLoader, InternalRuntimeManager runtimeManager) {
        this(DEFAULT_HOST, DEFAULT_KAFKA_CLIENT_ID, DEFAULT_SERIALIZER, DEFAULT_SERIALIZER, classLoader, runtimeManager);
    }

    public KafkaWorkItemHandler(String bootstrapServers, String clientId, String keySerializerClass, String valueSerializerClass) {
        this(bootstrapServers, clientId, keySerializerClass, valueSerializerClass, KafkaProducer.class.getClassLoader());
    }

    public KafkaWorkItemHandler(String bootstrapServers, String clientId, String keySerializerClass, String valueSerializerClass, ClassLoader classLoader) {
        this(bootstrapServers, clientId, keySerializerClass, valueSerializerClass, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaWorkItemHandler(String bootstrapServers, String clientId, String keySerializerClass, String valueSerializerClass, ClassLoader classLoader, InternalRuntimeManager runtimeManager) {
        String enableIdempotence;
        String retryBackOffMs;
        String retries;
        String requestTimeoutMs;
        String reconectBackOffMs;
        this.properties = new Properties();
        this.properties.put("bootstrap.servers", !this.isEmpty(bootstrapServers) ? bootstrapServers : DEFAULT_HOST);
        this.properties.put("client.id", !this.isEmpty(clientId) ? clientId : DEFAULT_KAFKA_CLIENT_ID);
        this.properties.put("key.serializer", !this.isEmpty(keySerializerClass) ? keySerializerClass : DEFAULT_SERIALIZER);
        this.properties.put("value.serializer", !this.isEmpty(valueSerializerClass) ? valueSerializerClass : DEFAULT_SERIALIZER);
        String reconnectBackoffMaxMs = System.getProperty(GLOBAL_RECONNECT_BACKOFF_MAX_MS);
        if (reconnectBackoffMaxMs != null) {
            this.properties.put("reconnect.backoff.max.ms", reconnectBackoffMaxMs);
        }
        if ((reconectBackOffMs = System.getProperty(GLOBAL_RECONNECT_BACKOFF_MS)) != null) {
            this.properties.put("reconnect.backoff.ms", reconectBackOffMs);
        }
        if ((requestTimeoutMs = System.getProperty(GLOBAL_REQUEST_TIMEOUT_MS)) != null) {
            this.properties.put("request.timeout.ms", requestTimeoutMs);
        }
        if ((retries = System.getProperty(GLOBAL_RETRIES)) != null) {
            this.properties.put("retries", retries);
        }
        if ((retryBackOffMs = System.getProperty(GLOBAL_RETRY_BACKOFF_MS)) != null) {
            this.properties.put("retry.backoff.ms", retryBackOffMs);
        }
        if ((enableIdempotence = System.getProperty(GLOBAL_ENABLE_IDEMPOTENCE)) != null) {
            this.properties.put("enable.idempotence", enableIdempotence);
        }
        if (runtimeManager != null) {
            this.executorService = (ExecutorService)runtimeManager.getEnvironment().getEnvironment().get("ExecutorService");
            LOG.info("Kafka WorkItem Handler Producer created with async {}", (Object)this.properties);
        } else {
            LOG.info("Kafka WorkItem Handler Producer created with sync for {}", (Object)this.properties);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            producers.computeIfAbsent(this.properties, config -> new KafkaProducer(config));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public boolean isEmpty(String val) {
        return val == null || val.isEmpty();
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String topic = (String)workItem.getParameter("Topic");
            Object key = workItem.getParameter("Key");
            Object value = workItem.getParameter("Value");
            if (this.executorService == null || !this.executorService.isActive()) {
                producers.get(this.properties).send(new ProducerRecord(topic, key, value)).get();
                HashMap<String, String> results = new HashMap<String, String>();
                results.put(RESULTS_VALUE, "success");
                manager.completeWorkItem(workItem.getId(), results);
            } else {
                CommandContext ctxCMD = new CommandContext();
                ctxCMD.setData("workItem", (Object)workItem);
                ctxCMD.setData("processInstanceId", (Object)this.getProcessInstanceId(workItem));
                ctxCMD.setData("deploymentId", (Object)((WorkItemImpl)workItem).getDeploymentId());
                ctxCMD.setData("callbacks", (Object)AsyncWorkItemHandlerCmdCallback.class.getName());
                ctxCMD.setData("topic", (Object)topic);
                ctxCMD.setData("key", key);
                ctxCMD.setData("value", value);
                ctxCMD.setData("producerProperties", (Object)this.properties);
                Long requestId = this.executorService.scheduleRequest(KafkaWorkItemHandlerProducerCommand.class.getName(), ctxCMD);
                LOG.debug("Request Kafka producer successfully with id {}", (Object)requestId);
            }
        }
        catch (Exception exp) {
            LOG.error("Handler error", (Throwable)exp);
            this.handleException(exp);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void close() {
        if (producers != null && producers.containsKey(this.properties)) {
            Producer producer = producers.remove(this.properties);
            producer.flush();
            producer.close();
        }
    }

    protected long getProcessInstanceId(WorkItem workItem) {
        return ((WorkItemImpl)workItem).getProcessInstanceId();
    }

    public static class KafkaWorkItemHandlerProducerCommand
    implements Command {
        public ExecutionResults execute(CommandContext ctx) throws Exception {
            String topic = (String)ctx.getData().get("topic");
            Object key = ctx.getData().get("key");
            Object value = ctx.getData().get("value");
            Properties properties = (Properties)ctx.getData().get("producerProperties");
            LOG.debug("Kafka WorkItem Handler {} about to send to topic {} key {} and value {}", new Object[]{properties, topic, key, value});
            ((Producer)producers.get(properties)).send(new ProducerRecord(topic, key, value)).get();
            LOG.debug("Kafka WorkItem Handler {} sent to topic {} key {} and value {}", new Object[]{properties, topic, key, value});
            ExecutionResults results = new ExecutionResults();
            results.setData(KafkaWorkItemHandler.RESULTS_VALUE, (Object)"success");
            return results;
        }
    }
}

