/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;

public class InMemoryKieServerTemplateStorage
implements KieServerTemplateStorage {
    private static InMemoryKieServerTemplateStorage INSTANCE = new InMemoryKieServerTemplateStorage();
    private Map<String, ServerTemplate> store = new HashMap<String, ServerTemplate>();
    private Map<String, ServerTemplateKey> storeKeys = new ConcurrentHashMap<String, ServerTemplateKey>();

    protected InMemoryKieServerTemplateStorage() {
    }

    public static InMemoryKieServerTemplateStorage getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate store(ServerTemplate serverTemplate) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.storeKeys.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            return this.store.put(serverTemplate.getId(), serverTemplate);
        }
    }

    public List<ServerTemplateKey> loadKeys() {
        return new ArrayList<ServerTemplateKey>(this.storeKeys.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerTemplate> load() {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            return this.store.values().stream().filter(Objects::nonNull).map(ServerTemplate::new).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate load(String identifier) {
        ServerTemplate serverTemplate = null;
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            serverTemplate = this.store.get(identifier);
        }
        return serverTemplate != null ? new ServerTemplate(serverTemplate) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String identifier) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            return this.store.containsKey(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate update(ServerTemplate serverTemplate) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.delete(serverTemplate.getId());
            this.store(serverTemplate);
        }
        return serverTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate delete(String identifier) {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.storeKeys.remove(identifier);
            return this.store.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, ServerTemplate> map = this.store;
        synchronized (map) {
            this.store.clear();
            this.storeKeys.clear();
        }
    }
}

