/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.extensions.StartTransactionExtendedResult;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartTransactionExtendedRequest
extends ExtendedRequest {
    public static final String START_TRANSACTION_REQUEST_OID = "1.3.6.1.1.21.1";
    private static final long serialVersionUID = 7382735226826929629L;

    public StartTransactionExtendedRequest() {
        super(START_TRANSACTION_REQUEST_OID);
    }

    public StartTransactionExtendedRequest(Control[] controls) {
        super(START_TRANSACTION_REQUEST_OID, controls);
    }

    public StartTransactionExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        if (extendedRequest.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_TXN_REQUEST_HAS_VALUE.get());
        }
    }

    public StartTransactionExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new StartTransactionExtendedResult(extendedResponse);
    }

    public StartTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public StartTransactionExtendedRequest duplicate(Control[] controls) {
        StartTransactionExtendedRequest r = new StartTransactionExtendedRequest(controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_TXN.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("StartTransactionExtendedRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    static {
        Object var0 = null;
    }
}

