/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.impl.Bpmn2FactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessVariableReader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessVariableReaderTest {
    private List<Property> properties;
    protected Property property1;
    protected Property property2;
    protected Property property3;
    protected Property property4;
    protected Property property5;
    @Mock
    protected ItemDefinition definition;

    @Before
    public void setup() {
        Mockito.when((Object)this.definition.getStructureRef()).thenReturn((Object)"Boolean");
        Bpmn2FactoryImpl bpmn2Factory = new Bpmn2FactoryImpl();
        this.property1 = bpmn2Factory.createProperty();
        this.property1.setName("PV1");
        this.property1.setId("PV1");
        this.property1.setItemSubjectRef(this.definition);
        CustomElement.customTags.of((BaseElement)this.property1).set((Object)"internal;input;customTag");
        this.property2 = bpmn2Factory.createProperty();
        this.property2.setName(null);
        this.property2.setId("PV2");
        this.property3 = bpmn2Factory.createProperty();
        this.property3.setName("");
        this.property3.setId("PV3");
        this.property4 = bpmn2Factory.createProperty();
        this.property4.setName("caseFile_CV4");
        this.property4.setId("caseFile_CV4");
        this.property5 = bpmn2Factory.createProperty();
        this.property5.setName(null);
        this.property5.setId("caseFile_CV5");
        this.properties = new ArrayList<Property>();
        this.properties.add(this.property1);
        this.properties.add(this.property2);
        this.properties.add(this.property3);
        this.properties.add(this.property4);
        this.properties.add(this.property5);
    }

    @Test
    public void getProcessVariables() {
        String result = ProcessVariableReader.getProcessVariables(this.properties);
        Assert.assertEquals((Object)"PV1:Boolean:<![CDATA[internal;input;customTag]]>,PV2::[],PV3::[]", (Object)result);
    }

    @Test
    public void getProcessVariableName() {
        Assert.assertEquals((Object)"PV1", (Object)ProcessVariableReader.getProcessVariableName((Property)this.property1));
        Assert.assertEquals((Object)"PV2", (Object)ProcessVariableReader.getProcessVariableName((Property)this.property2));
        Assert.assertEquals((Object)"PV3", (Object)ProcessVariableReader.getProcessVariableName((Property)this.property3));
        Assert.assertEquals((Object)"caseFile_CV4", (Object)ProcessVariableReader.getProcessVariableName((Property)this.property4));
        Assert.assertEquals((Object)"caseFile_CV5", (Object)ProcessVariableReader.getProcessVariableName((Property)this.property5));
    }

    @Test
    public void isProcessVariable() {
        Assert.assertTrue((boolean)ProcessVariableReader.isProcessVariable((Property)this.property1));
        Assert.assertTrue((boolean)ProcessVariableReader.isProcessVariable((Property)this.property2));
        Assert.assertTrue((boolean)ProcessVariableReader.isProcessVariable((Property)this.property3));
        Assert.assertFalse((boolean)ProcessVariableReader.isProcessVariable((Property)this.property4));
        Assert.assertFalse((boolean)ProcessVariableReader.isProcessVariable((Property)this.property5));
    }
}

