/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDTGraphXMLPersistence;
import org.drools.workbench.screens.guided.dtable.backend.server.GuidedDecisionTableModelVisitor;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.DecisionTableGuidedToDecisionTableXLSConverter;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResult;
import org.drools.workbench.screens.guided.dtable.type.GuidedDTableGraphResourceTypeDefinition;
import org.drools.workbench.screens.workitems.service.WorkItemsEditorService;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.FileExtensionFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.VersionRecordService;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class GuidedDecisionTableEditorServiceImpl
extends KieService<GuidedDecisionTableEditorContent>
implements GuidedDecisionTableEditorService {
    private IOService ioService;
    private CopyService copyService;
    private DeleteService deleteService;
    private RenameService renameService;
    private DataModelService dataModelService;
    private WorkItemsEditorService workItemsService;
    private KieModuleService moduleService;
    private VersionRecordService versionRecordService;
    private GuidedDecisionTableGraphEditorService dtableGraphService;
    private GuidedDTableGraphResourceTypeDefinition dtableGraphType;
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    private GenericValidator genericValidator;
    private CommentedOptionFactory commentedOptionFactory;
    private SafeSessionInfo safeSessionInfo;
    private SaveAndRenameServiceImpl<GuidedDecisionTable52, Metadata> saveAndRenameService;
    private DecisionTableGuidedToDecisionTableXLSConverter decisionTableGuidedToDecisionTableXLSConverter;

    public GuidedDecisionTableEditorServiceImpl() {
    }

    @Inject
    public GuidedDecisionTableEditorServiceImpl(@Named(value="ioStrategy") IOService ioService, CopyService copyService, DeleteService deleteService, RenameService renameService, DataModelService dataModelService, WorkItemsEditorService workItemsService, KieModuleService moduleService, VersionRecordService versionRecordService, GuidedDecisionTableGraphEditorService dtableGraphService, DecisionTableGuidedToDecisionTableXLSConverter decisionTableGuidedToDecisionTableXLSConverter, GuidedDTableGraphResourceTypeDefinition dtableGraphType, Event<ResourceOpenedEvent> resourceOpenedEvent, GenericValidator genericValidator, CommentedOptionFactory commentedOptionFactory, SaveAndRenameServiceImpl<GuidedDecisionTable52, Metadata> saveAndRenameService, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.copyService = copyService;
        this.deleteService = deleteService;
        this.renameService = renameService;
        this.dataModelService = dataModelService;
        this.workItemsService = workItemsService;
        this.moduleService = moduleService;
        this.versionRecordService = versionRecordService;
        this.dtableGraphService = dtableGraphService;
        this.decisionTableGuidedToDecisionTableXLSConverter = decisionTableGuidedToDecisionTableXLSConverter;
        this.dtableGraphType = dtableGraphType;
        this.resourceOpenedEvent = resourceOpenedEvent;
        this.genericValidator = genericValidator;
        this.commentedOptionFactory = commentedOptionFactory;
        this.saveAndRenameService = saveAndRenameService;
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, GuidedDecisionTable52 content, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(context);
            String packageName = pkg == null ? null : pkg.getPackageName();
            content.setPackageName(packageName);
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, GuidedDTXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTable52 load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return GuidedDTXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public GuidedDecisionTableEditorContent loadContent(org.uberfire.backend.vfs.Path path) {
        return (GuidedDecisionTableEditorContent)super.loadContent(path);
    }

    protected GuidedDecisionTableEditorContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        GuidedDecisionTable52 model = this.load(path);
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        GuidedDecisionTableModelVisitor visitor = new GuidedDecisionTableModelVisitor(model);
        Set<String> consumedFQCNs = visitor.getConsumedModelClasses();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        consumedFQCNs.addAll(oracle.getModuleCollectionTypes().entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        Set workItemDefinitions = this.workItemsService.loadWorkItemDefinitions(path);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new GuidedDecisionTableEditorContent(model, workItemDefinitions, overview, dataModel);
    }

    public PackageDataModelOracleBaselinePayload loadDataModel(org.uberfire.backend.vfs.Path path) {
        try {
            PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
            PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
            DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, new HashSet());
            return dataModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, GuidedDecisionTable52 model, Metadata metadata, String comment) {
        try {
            Package pkg = this.moduleService.resolvePackage(resource);
            String packageName = pkg == null ? null : pkg.getPackageName();
            model.setPackageName(packageName);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), GuidedDTXMLPersistence.getInstance().marshal(model), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndUpdateGraphEntries(org.uberfire.backend.vfs.Path resource, GuidedDecisionTable52 model, Metadata metadata, String comment) {
        try {
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)resource).getFileSystem());
            this.save(resource, model, metadata, comment);
            this.updateGraphElementPaths(resource, this.getLatestVersionPath(resource));
            org.uberfire.backend.vfs.Path path = resource;
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public XLSConversionResult convert(org.uberfire.backend.vfs.Path path) {
        try {
            return this.decisionTableGuidedToDecisionTableXLSConverter.convert(path);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private org.uberfire.backend.vfs.Path getLatestVersionPath(org.uberfire.backend.vfs.Path path) {
        List versions = this.versionRecordService.load(Paths.convert((org.uberfire.backend.vfs.Path)path));
        String versionUri = ((VersionRecord)versions.get(versions.size() - 1)).uri();
        return PathFactory.newPathBasedOn((String)path.getFileName(), (String)versionUri, (org.uberfire.backend.vfs.Path)path);
    }

    private void updateGraphElementPaths(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(this.getParentFolder(source), (DirectoryStream.Filter)new FileExtensionFilter(this.dtableGraphType.getSuffix()));){
            directoryStream.forEach(path -> this.updateGraphElementPath(source, destination, Paths.convert((Path)path)));
        }
    }

    private Path getParentFolder(org.uberfire.backend.vfs.Path path) {
        Path nioFolderPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return Files.isDirectory((Path)nioFolderPath, (LinkOption[])new LinkOption[0]) ? nioFolderPath : nioFolderPath.getParent();
    }

    private void updateGraphElementPath(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination, org.uberfire.backend.vfs.Path graphPath) {
        GuidedDecisionTableEditorGraphModel dtGraphModel = (GuidedDecisionTableEditorGraphModel)this.dtableGraphService.load(graphPath);
        Set dtGraphEntries = dtGraphModel.getEntries();
        dtGraphEntries.stream().filter(e -> e.getPathHead().equals(source)).forEach(e -> e.setPathVersion(destination));
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)graphPath), GuidedDTGraphXMLPersistence.getInstance().marshal(dtGraphModel), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("Updated Path version for [" + source.toURI() + "] to [" + destination.toURI() + "].")});
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String toSource(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 model) {
        return this.sourceServices.getServiceFor(Paths.convert((org.uberfire.backend.vfs.Path)path)).getSource(Paths.convert((org.uberfire.backend.vfs.Path)path), (Object)model);
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, GuidedDecisionTable52 content) {
        try {
            return this.genericValidator.validate(path, GuidedDTXMLPersistence.getInstance().marshal(content));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, GuidedDecisionTable52 content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }
}

