/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.CompositeFieldConstraint;
import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.models.datamodel.rule.FieldConstraint;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.SingleFieldConstraint;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.util.VariableOperators;

public class ConstraintVisitor {
    private final List<String> result = new ArrayList<String>();
    private final IPattern iPattern;
    private final Map<IPattern, List<String>> conditionVariablesByDefinition;
    private final VariableOperators variableOperators;

    public ConstraintVisitor(IPattern iPattern, Map<IPattern, List<String>> conditionVariablesByDefinition, VariableOperators variableOperators) {
        this.iPattern = iPattern;
        this.conditionVariablesByDefinition = conditionVariablesByDefinition;
        this.variableOperators = variableOperators;
    }

    public Collection<? extends String> visit() {
        for (FieldConstraint constraint : ((FactPattern)this.iPattern).getConstraintList().getConstraints()) {
            this.visit(constraint);
        }
        return this.result;
    }

    private void visit(FieldConstraint constraint) {
        if (constraint instanceof SingleFieldConstraint && ((SingleFieldConstraint)constraint).getConstraintValueType() == 7) {
            String variable = ((SingleFieldConstraint)constraint).getValue();
            this.result.add(variable);
            this.conditionVariablesByDefinition.get(this.iPattern).add(variable);
            this.variableOperators.append(variable, ((SingleFieldConstraint)constraint).getOperator());
        } else if (constraint instanceof CompositeFieldConstraint && ((CompositeFieldConstraint)constraint).getConstraints() != null) {
            for (FieldConstraint fieldConstraint : ((CompositeFieldConstraint)constraint).getConstraints()) {
                this.visit(fieldConstraint);
            }
        }
    }
}

