/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Directory {
    private String name;
    private Map<String, List<String>> tagMap;
    private String fullPath;
    private Directory parent;
    private String URI;
    private List<Directory> childsDirectories = new ArrayList<Directory>();
    private List<String> childComponents = new ArrayList<String>();

    public Directory() {
    }

    public Directory(String name, String fullPath, String URI, Directory parent) {
        this.name = name;
        this.fullPath = fullPath;
        this.parent = parent;
        this.URI = URI;
        this.tagMap = parent.getTagMap();
        this.setupChildComponents();
    }

    public Directory(String name, String fullPath, String URI, Map<String, List<String>> tagMap) {
        this.fullPath = fullPath;
        this.name = name;
        this.URI = URI;
        this.tagMap = tagMap;
        this.setupChildComponents();
    }

    private void setupChildComponents() {
        List<String> components = this.tagMap.get(this.name.toUpperCase());
        if (components != null) {
            this.childComponents.addAll(components);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Directory> getChildsDirectories() {
        return this.childsDirectories;
    }

    public void addChildDirectory(Directory directory) {
        this.childsDirectories.add(directory);
    }

    public void addChildDirectories(List<Directory> directories) {
        this.childsDirectories.addAll(directories);
    }

    public Directory getParent() {
        return this.parent;
    }

    public String getURI() {
        return this.URI;
    }

    public Map<String, List<String>> getTagMap() {
        return this.tagMap;
    }

    public List<String> getChildComponents() {
        return this.childComponents;
    }

    public void removeChildDirectoryByURI(String uri) {
        Directory candidate = null;
        for (Directory child : this.childsDirectories) {
            if (!child.getURI().equalsIgnoreCase(uri)) continue;
            candidate = child;
            break;
        }
        if (candidate != null) {
            this.childsDirectories.remove(candidate);
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean alreadyHasChild(String dirName) {
        for (Directory child : this.childsDirectories) {
            if (!child.getName().equalsIgnoreCase(dirName)) continue;
            return true;
        }
        return false;
    }
}

