/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, name = "NodeFilter", namespace = JsPackage.GLOBAL)
class NodeFilter__Constants {
  static double FILTER_ACCEPT;
  static double FILTER_REJECT;
  static double FILTER_SKIP;
  static double SHOW_ALL;
  static double SHOW_ATTRIBUTE;
  static double SHOW_CDATA_SECTION;
  static double SHOW_COMMENT;
  static double SHOW_DOCUMENT;
  static double SHOW_DOCUMENT_FRAGMENT;
  static double SHOW_DOCUMENT_TYPE;
  static double SHOW_ELEMENT;
  static double SHOW_ENTITY;
  static double SHOW_ENTITY_REFERENCE;
  static double SHOW_NOTATION;
  static double SHOW_PROCESSING_INSTRUCTION;
  static double SHOW_TEXT;
}
