/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.definition.clone;

import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.databinding.client.BindableProxyFactory;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.clone.AbstractCloneProcess;
import org.kie.workbench.common.stunner.core.definition.clone.IDeepCloneProcess;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.util.ClassUtils;

@ApplicationScoped
public class DeepCloneProcess
extends AbstractCloneProcess
implements IDeepCloneProcess {
    private final ClassUtils classUtils;

    protected DeepCloneProcess() {
        this(null, null, null);
    }

    @Inject
    public DeepCloneProcess(FactoryManager factoryManager, AdapterManager adapterManager, ClassUtils classUtils) {
        super(factoryManager, adapterManager);
        this.classUtils = classUtils;
    }

    @Override
    public <S, T> T clone(S source, T target) {
        AdapterRegistry adapters = this.adapterManager.registry();
        DefinitionAdapter sourceDefinitionAdapter = adapters.getDefinitionAdapter(source.getClass());
        for (String field : sourceDefinitionAdapter.getPropertyFields(source)) {
            Optional property = sourceDefinitionAdapter.getProperty(source, field);
            property.ifPresent(p -> {
                Object value = adapters.getPropertyAdapter(p.getClass()).getValue(p);
                if (null != value && this.isAllowedToClone(value)) {
                    Optional targetProperty = adapters.getDefinitionAdapter(target.getClass()).getProperty(target, field);
                    targetProperty.ifPresent(tp -> {
                        PropertyAdapter tpa = adapters.getPropertyAdapter(tp.getClass());
                        tpa.setValue(tp, value);
                    });
                }
            });
        }
        return target;
    }

    private boolean isAllowedToClone(Object value) {
        return Objects.nonNull(value) && (this.isSimpleValue(value) || BindableProxyFactory.isBindableType((Object)value));
    }

    private boolean isSimpleValue(Object value) {
        return value instanceof String || this.classUtils.isPrimitiveClass(value.getClass());
    }
}

