/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.commons.shared.layout.impl;

import java.util.List;
import org.kie.workbench.common.forms.commons.shared.layout.FormLayoutTemplateGenerator;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public abstract class AbstractFormLayoutTemplateGenerator
implements FormLayoutTemplateGenerator {
    @Override
    public void generateLayoutTemplate(FormDefinition formDefinition) {
        formDefinition.setLayoutTemplate(new LayoutTemplate());
        this.addFieldsToTemplate(formDefinition.getLayoutTemplate(), formDefinition.getFields(), formDefinition.getId());
    }

    @Override
    public void updateLayoutTemplate(FormDefinition form, List<FieldDefinition> newFields) {
        newFields.forEach(newField -> {
            if (form.getFieldById(newField.getId()) == null) {
                form.getFields().add(newField);
            }
        });
        if (form.getLayoutTemplate() == null || form.getLayoutTemplate().isEmpty()) {
            this.generateLayoutTemplate(form);
            return;
        }
        this.addFieldsToTemplate(form.getLayoutTemplate(), newFields, form.getId());
    }

    protected void addFieldsToTemplate(LayoutTemplate template, List<FieldDefinition> fields, String formId) {
        fields.forEach(field -> {
            LayoutComponent layoutComponent = new LayoutComponent(this.getDraggableType());
            layoutComponent.addProperty("form_id", formId);
            layoutComponent.addProperty("field_id", field.getId());
            LayoutColumn column = new LayoutColumn("12");
            column.add(layoutComponent);
            LayoutRow row = new LayoutRow();
            row.add(column);
            template.addRow(row);
        });
    }
}

