/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.index.DataSetIndex;
import org.dashbuilder.dataset.filter.DataSetFilter;

public class StaticDataSetProvider
implements DataSetProvider {
    private SharedDataSetOpEngine dataSetOpEngine;

    public StaticDataSetProvider() {
    }

    public StaticDataSetProvider(SharedDataSetOpEngine dataSetOpEngine) {
        this.dataSetOpEngine = dataSetOpEngine;
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.STATIC;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) {
        DataSet dataSet = this.lookupDataSet(def, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    public void registerDataSet(DataSet dataSet) {
        this.dataSetOpEngine.getIndexRegistry().put(dataSet);
    }

    public DataSet removeDataSet(String uuid) {
        DataSetIndex index = this.dataSetOpEngine.getIndexRegistry().remove(uuid);
        return index == null ? null : index.getDataSet();
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) {
        DataSet dataSet;
        String uuid = def.getUUID();
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            return null;
        }
        boolean isRoot = lookup == null || lookup.isEmpty();
        DataSetFilter filter = def.getDataSetFilter();
        if (filter != null) {
            if (lookup == null) {
                lookup = new DataSetLookup(uuid, new DataSetOp[]{filter});
            } else {
                lookup.addOperation(0, new DataSetOp[]{filter});
            }
        }
        if ((dataSet = this.lookupDataSet(uuid, lookup)) != null && isRoot) {
            dataSet.setUUID(uuid);
            dataSet.setDefinition(def);
        }
        return dataSet;
    }

    public DataSet lookupDataSet(String uuid, DataSetLookup lookup) {
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            return null;
        }
        DataSetIndex dataSetIndex = this.dataSetOpEngine.getIndexRegistry().get(uuid);
        if (dataSetIndex == null) {
            return null;
        }
        DataSet dataSet = dataSetIndex.getDataSet();
        if (lookup == null) {
            return dataSet;
        }
        if (!lookup.getOperationList().isEmpty()) {
            dataSet = this.dataSetOpEngine.execute(uuid, lookup.getOperationList());
        }
        dataSet = dataSet.trim(lookup.getRowOffset(), lookup.getNumberOfRows());
        return dataSet;
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        return false;
    }
}

