/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import javax.servlet.FilterConfig;

public class SecureHeadersConfig {
    private final Long maxAge;
    private final Boolean includeSubDomains;
    private final String location;
    private final String frameOptions;
    private final String xssOptions;

    public SecureHeadersConfig(FilterConfig config) {
        String _maxAge = config.getInitParameter("max-age");
        this.maxAge = _maxAge != null ? Long.valueOf(_maxAge) : null;
        String _includeSubDomains = config.getInitParameter("include-subdomains");
        this.includeSubDomains = _includeSubDomains != null ? Boolean.valueOf(_includeSubDomains) : Boolean.valueOf(false);
        this.location = config.getInitParameter("Location");
        this.frameOptions = config.getInitParameter("x-frame-options");
        String _xssOptionsEnable = config.getInitParameter("x-xss-protection-enable");
        String _xssOptionsBlock = config.getInitParameter("x-xss-protection-block");
        if (_xssOptionsEnable == null) {
            this.xssOptions = null;
        } else {
            String _xssOptions = this.toBoolean(_xssOptionsEnable, false) ? "1" : "0";
            if (this.toBoolean(_xssOptionsBlock, false)) {
                _xssOptions = _xssOptions + "; mode=block";
            }
            this.xssOptions = _xssOptions;
        }
    }

    private boolean toBoolean(String value, boolean defaultValue) {
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public String getMaxAge() {
        StringBuilder header = new StringBuilder("max-age=" + this.maxAge);
        if (this.includeSubDomains.booleanValue()) {
            header.append("; includeSubdomains");
        }
        return header.toString();
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameOptions() {
        return this.frameOptions;
    }

    public boolean hasMaxAge() {
        return this.maxAge != null && this.maxAge >= 0L;
    }

    public boolean hasLocation() {
        return this.isEmpty(this.location);
    }

    public boolean hasFrameOptions() {
        return this.isEmpty(this.frameOptions);
    }

    public boolean hasXSSOptions() {
        return this.isEmpty(this.xssOptions);
    }

    public String getXssOptions() {
        return this.xssOptions;
    }

    private boolean isEmpty(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

