/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import java.util.ArrayList;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.RootElement;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.EventPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorRef;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.MessageRef;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class EventPropertyWriterTest {
    private static final String EMPTY_STRING = "";
    private static final String NON_EMPTY_STRING = "nomEmpty";
    private static final String SAMPLE_STRUCTURE_REF = "my.var.ref";
    protected static final String ERROR_CODE = "ERROR_CODE";
    protected static final String elementId = "MY_ID";
    protected Event event;
    protected EventPropertyWriter propertyWriter;

    @Test
    public void testMessageStructureRef() {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        itemDefinitions.add(itemDefinition);
        Mockito.when((Object)itemDefinition.getStructureRef()).thenReturn((Object)SAMPLE_STRUCTURE_REF);
        Mockito.when((Object)this.propertyWriter.getItemDefinitions()).thenReturn(itemDefinitions);
        MessageRef messageRef1 = new MessageRef("someVar", EMPTY_STRING);
        this.propertyWriter.addMessage(messageRef1);
        Assert.assertEquals((Object)SAMPLE_STRUCTURE_REF, (Object)messageRef1.getStructure());
        MessageRef messageRef2 = new MessageRef("someVar", NON_EMPTY_STRING);
        this.propertyWriter.addMessage(messageRef2);
        Assert.assertEquals((Object)SAMPLE_STRUCTURE_REF, (Object)messageRef2.getStructure());
        itemDefinitions.clear();
        MessageRef messageRef3 = new MessageRef("someVar", NON_EMPTY_STRING);
        this.propertyWriter.addMessage(messageRef3);
        Assert.assertEquals((Object)EMPTY_STRING, (Object)messageRef3.getStructure());
    }

    @Test
    public void testAddEmptyError() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(RootElement.class);
        ErrorRef errorRef = new ErrorRef();
        this.propertyWriter.addError(errorRef);
        ErrorEventDefinition definition = this.getErrorDefinition();
        Assert.assertNull((Object)definition.getErrorRef().getErrorCode());
        Assert.assertFalse((boolean)definition.getErrorRef().getId().isEmpty());
        ((EventPropertyWriter)Mockito.verify((Object)this.propertyWriter)).addRootElement((RootElement)captor.capture());
        Error error = (Error)captor.getValue();
        Assert.assertNull((Object)error.getErrorCode());
        Assert.assertFalse((boolean)error.getId().isEmpty());
    }

    @Test
    public void testAddError() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(RootElement.class);
        ErrorRef errorRef = new ErrorRef();
        errorRef.setValue(ERROR_CODE);
        this.propertyWriter.addError(errorRef);
        ErrorEventDefinition definition = this.getErrorDefinition();
        Assert.assertEquals((Object)ERROR_CODE, (Object)definition.getErrorRef().getErrorCode());
        Assert.assertFalse((boolean)definition.getErrorRef().getId().isEmpty());
        ((EventPropertyWriter)Mockito.verify((Object)this.propertyWriter)).addRootElement((RootElement)captor.capture());
        Error error = (Error)captor.getValue();
        Assert.assertEquals((Object)ERROR_CODE, (Object)error.getErrorCode());
        Assert.assertFalse((boolean)error.getId().isEmpty());
    }

    public abstract ErrorEventDefinition getErrorDefinition();
}

