/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.EndEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.EndErrorEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.ErrorEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EndErrorEventTest
extends EndEventTest<EndErrorEvent> {
    private static final String BPMN_END_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endErrorEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_2E09ED8C-6B13-49C1-B7BE-9D4D152FF691";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_998BB72E-AA24-4814-99CC-A7A7AA9EE976";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_1F52246B-41C6-495D-B91A-0703BA9F2D9E";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_01DE8A98-96FD-4575-B9AA-07C04A54255A";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_A050459F-39A4-4D45-8F67-BBB41D49CC6B";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_BFDCF173-E6EB-44B3-B68E-616382B9D858";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_5DC3BF07-4A4B-4994-B571-24CA6C22C8A2";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_1FC5A7E1-A787-47D4-9B81-5FF13441E814";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 14;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error01";
        String EVENT_DATA_OUTPUT = "error01:String||||[din]processGlobalVar->error01";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent filledTopEvent = (EndErrorEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "end event01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledTopEvent.getExecutionSet(), "error01");
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "error01:String||||[din]processGlobalVar->error01");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent emptyTopEvent = (EndErrorEvent)this.getEndNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error03";
        String EVENT_DATA_OUTPUT = "error03:String||||[din]processGlobalVar->error03";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent filledSubprocessEvent = (EndErrorEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error03");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "error03:String||||[din]processGlobalVar->error03");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent emptySubprocessEvent = (EndErrorEvent)this.getEndNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error02";
        String EVENT_DATA_OUTPUT = "error02:String||||[din]processGlobalVar->error02";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent filledSubprocessEvent = (EndErrorEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error02");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "error02:String||||[din]processGlobalVar->error02");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent emptyEvent = (EndErrorEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent emptySubprocessEvent = (EndErrorEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "error04";
        String EVENT_DATA_OUTPUT = "error04:String||||[din]processGlobalVar->error04";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndErrorEvent filledSubprocessEvent = (EndErrorEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "end event04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "end event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertErrorEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "error04");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "error04:String||||[din]processGlobalVar->error04");
    }

    @Override
    String getBpmnEndEventFilePath() {
        return BPMN_END_EVENT_FILE_PATH;
    }

    @Override
    Class<EndErrorEvent> getEndEventType() {
        return EndErrorEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertErrorEventExecutionSet(ErrorEventExecutionSet executionSet, String eventName) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getErrorRef());
        Assert.assertEquals((Object)eventName, (Object)executionSet.getErrorRef().getValue());
    }
}

