/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.StartEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.StartCompensationEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class StartCompensationEventTest
extends StartEventTest<StartCompensationEvent> {
    private static final String BPMN_START_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/startCompensationEvents.bpmn";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_444DDF3E-FFE6-457F-8A67-3ED71EDB9926";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_3F8B50F0-66F7-4992-B279-41E6A6E20A6B";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_B02E67E6-2248-41E7-A284-9EB84496CEDE";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_5BFE7259-E518-4D2E-9FE9-7BD9680390EC";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 10;
    private static final String SLA_DUE_DATE = "P1y8m17dT23h19m38s";

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Start compensation event01 name\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Start compensation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartCompensationEvent filledTopLevelEvent = (StartCompensationEvent)this.getStartNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledTopLevelEvent.getGeneral(), "Start compensation event01 name\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Start compensation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        Assert.assertNotNull((Object)filledTopLevelEvent.getExecutionSet());
        this.assertStartEventSlaDueDate(filledTopLevelEvent.getExecutionSet(), SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartCompensationEvent emptyTopLevelEvent = (StartCompensationEvent)this.getStartNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptyTopLevelEvent.getGeneral(), "", "");
        Assert.assertNotNull((Object)emptyTopLevelEvent.getExecutionSet());
        this.assertStartEventSlaDueDate(emptyTopLevelEvent.getExecutionSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Start compensation event02 name\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Start compensation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartCompensationEvent filledSubprocessLevelEvent = (StartCompensationEvent)this.getStartNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(filledSubprocessLevelEvent.getGeneral(), "Start compensation event02 name\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Start compensation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        Assert.assertNotNull((Object)filledSubprocessLevelEvent.getExecutionSet());
        this.assertStartEventSlaDueDate(filledSubprocessLevelEvent.getExecutionSet(), SLA_DUE_DATE);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 10);
        StartCompensationEvent emptySubprocessLevelEvent = (StartCompensationEvent)this.getStartNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID);
        this.assertGeneralSet(emptySubprocessLevelEvent.getGeneral(), "", "");
        Assert.assertNotNull((Object)emptySubprocessLevelEvent.getExecutionSet());
        this.assertStartEventSlaDueDate(emptySubprocessLevelEvent.getExecutionSet(), "");
    }

    @Override
    String getBpmnStartEventFilePath() {
        return BPMN_START_EVENT_FILE_PATH;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    Class<StartCompensationEvent> getStartEventType() {
        return StartCompensationEvent.class;
    }
}

