/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workitem.google.mail;

import com.google.api.client.util.Base64;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.workitem.google.mail.GoogleMailAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="GoogleSendMailDefinitions.wid", name="GoogleSendMail", displayName="GoogleSendMail", defaultHandler="mvel: new org.jbpm.process.workitem.google.mail.SendMailWorkitemHandler(\"appName\", \"clentSecret\")", documentation="google-mail-workitem/index.html", category="google-mail-workitem", icon="GoogleSendMail.png", parameters={@WidParameter(name="To"), @WidParameter(name="From"), @WidParameter(name="Subject"), @WidParameter(name="BodyText"), @WidParameter(name="Attachment", runtimeType="org.jbpm.document.Document")}, results={@WidResult(name="Message", runtimeType="com.google.api.services.gmail.model.Message")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="google-mail-workitem", version="7.59.0.Final")}, serviceInfo=@WidService(category="Google Mail", description="Send mail via Google", keywords="google,mail,email,send", action=@WidAction(title="Send email using Google Mail"), authinfo=@WidAuth(required=true, params={"appName", "clentSecret"}, paramsdescription={"Google app name", "Google client secret"}, referencesite="https://developers.google.com/gmail/api/auth/about-auth")))
public class SendMailWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String appName;
    private String clientSecret;
    private GoogleMailAuth auth = new GoogleMailAuth();

    public SendMailWorkitemHandler(String appName, String clentSecret) {
        this.appName = appName;
        this.clientSecret = clentSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        String paramTo = (String)workItem.getParameter("To");
        String paramFrom = (String)workItem.getParameter("From");
        String paramSubject = (String)workItem.getParameter("Subject");
        String paramBodyText = (String)workItem.getParameter("BodyText");
        Document paramAttachment = (Document)workItem.getParameter("Attachment");
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            Gmail gmailService = this.auth.getGmailService(this.appName, this.clientSecret);
            Message outEmailMessage = this.sendMessage(gmailService, paramTo, paramFrom, paramSubject, paramBodyText, paramAttachment);
            workItemManager.completeWorkItem(workItem.getId(), (Map)outEmailMessage);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public Message sendMessage(Gmail service, String to, String from, String subject, String bodyText, Document attachment) throws MessagingException, IOException {
        MimeMessage mimeMessage = this.createEmailWithAttachment(to, from, subject, bodyText, attachment);
        Message message = (Message)service.users().messages().send(from, SendMailWorkitemHandler.createMessageWithEmail(mimeMessage)).execute();
        return message;
    }

    public static Message createMessageWithEmail(MimeMessage emailContent) throws MessagingException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        emailContent.writeTo((OutputStream)buffer);
        byte[] bytes = buffer.toByteArray();
        String encodedEmail = Base64.encodeBase64URLSafeString((byte[])bytes);
        Message message = new Message();
        message.setRaw(encodedEmail);
        return message;
    }

    public MimeMessage createEmailWithAttachment(String to, String from, String subject, String bodyText, Document attachment) throws MessagingException, IOException {
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage email = new MimeMessage(session);
        email.setFrom((Address)new InternetAddress(from));
        email.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        email.setSubject(subject);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)bodyText, "text/plain");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)mimeBodyPart);
        if (attachment != null) {
            mimeBodyPart = new MimeBodyPart();
            InputStreamDataSource source = new InputStreamDataSource(new ByteArrayInputStream(attachment.getContent()));
            mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
            mimeBodyPart.setFileName(attachment.getName());
            multipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        email.setContent((Multipart)multipart);
        return email;
    }

    public void setAuth(GoogleMailAuth auth) {
        this.auth = auth;
    }

    public class InputStreamDataSource
    implements DataSource {
        private InputStream inputStream;

        public InputStreamDataSource(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getContentType() {
            return "*/*";
        }

        public String getName() {
            return "InputStreamDataSource";
        }
    }
}

