/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DateFunctions {
    DATE_DAYS_SINCE_YEAR("dateDaysSinceYear"),
    DATE_SECONDS_SINCE_YEAR("dateSecondsSinceYear"),
    DATE_SECONDS_SINCE_MIDNIGHT("dateSecondsSinceMidnight");

    private final String name;
    private static final Logger logger;
    private static final long MILLISECONDS_PER_DAY = 86400000L;

    private DateFunctions(String name) {
        this.name = name;
    }

    public static boolean isDateFunctions(String name) {
        return Arrays.stream(DateFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static DateFunctions byName(String name) {
        return Arrays.stream(DateFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find DateFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case DATE_DAYS_SINCE_YEAR: {
                return this.dateDaysSinceYear(inputData);
            }
            case DATE_SECONDS_SINCE_YEAR: {
                return this.dateSecondsSinceYear(inputData);
            }
            case DATE_SECONDS_SINCE_MIDNIGHT: {
                return this.dateSecondsSinceMidnight(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged DateFunctions " + (Object)((Object)this));
    }

    private int dateDaysSinceYear(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 2);
        BUILTIN_FUNCTIONS.checkDate(inputData[0]);
        BUILTIN_FUNCTIONS.checkInteger(inputData[1]);
        LocalDateTime referredDate = LocalDateTime.of((int)((Integer)inputData[1]), 1, 1, 0, 0, 0);
        LocalDateTime referringDate = ((Date)inputData[0]).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return (int)ChronoUnit.DAYS.between(referredDate, referringDate);
    }

    private int dateSecondsSinceYear(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 2);
        BUILTIN_FUNCTIONS.checkDate(inputData[0]);
        BUILTIN_FUNCTIONS.checkInteger(inputData[1]);
        Date yearDate = new GregorianCalendar((Integer)inputData[1], 0, 1).getTime();
        long diff = ((Date)inputData[0]).getTime() - yearDate.getTime();
        return (int)TimeUnit.SECONDS.convert(diff, TimeUnit.MILLISECONDS);
    }

    private int dateSecondsSinceMidnight(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkDates(inputData, 1);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)inputData[0]);
        gregorianCalendar.set(10, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        Date midnight = gregorianCalendar.getTime();
        long diff = ((Date)inputData[0]).getTime() - midnight.getTime();
        return (int)TimeUnit.SECONDS.convert(diff, TimeUnit.MILLISECONDS);
    }

    static {
        logger = LoggerFactory.getLogger(DateFunctions.class);
    }
}

