/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.camel.request;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.jbpm.process.workitem.camel.request.RequestMapper;

public class RequestPayloadMapper
implements RequestMapper {
    private final String requestLocation;
    private final Set<String> headerLocations;

    public RequestPayloadMapper() {
        this("request");
    }

    public RequestPayloadMapper(String requestLocation) {
        this(requestLocation, new HashSet<String>());
    }

    public RequestPayloadMapper(String requestLocation, Set<String> headerLocations) {
        this.requestLocation = requestLocation;
        this.headerLocations = headerLocations;
    }

    @Override
    public Processor mapToRequest(Map<String, Object> params) {
        Object request = params.remove(this.requestLocation);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String headerLocation : this.headerLocations) {
            if (!params.containsKey(headerLocation)) continue;
            headers.put(headerLocation, params.remove(headerLocation));
        }
        return new RequestProcessor(request, headers);
    }

    protected class RequestProcessor
    implements Processor {
        private Object payload;
        private Map<String, Object> headers;

        public RequestProcessor(Object payload, Map<String, Object> headers) {
            this.payload = payload;
            this.headers = headers;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setBody(this.payload);
            exchange.getIn().setHeaders(this.headers);
        }
    }
}

