/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.transfer;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.ext.layout.editor.api.PerspectiveServices;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

@ApplicationScoped
public class LayoutComponentHelper {
    @Inject
    private PerspectiveServices perspectiveServices;

    public List<String> findComponentsInTemplates(Predicate<String> pageFilter) {
        return this.perspectiveServices.listLayoutTemplates().stream().filter(lt -> pageFilter.test(lt.getName())).map(LayoutTemplate::getRows).flatMap(this::allComponentsStream).map(lt -> (String)lt.getProperties().get("componentId")).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<LayoutComponent> allComponentsStream(List<LayoutRow> row) {
        return row.stream().flatMap(r -> r.getLayoutColumns().stream()).flatMap(cl -> Stream.concat(cl.getLayoutComponents().stream(), this.allComponentsStream(cl.getRows())));
    }
}

