/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.executor;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.tree.compiler.factories.KiePMMLTreeModelFactory;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;
import org.kie.pmml.models.tree.model.KiePMMLTreeModelWithSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeModelImplementationProvider
implements ModelImplementationProvider<TreeModel, KiePMMLTreeModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)TreeModelImplementationProvider.class.getName());

    public PMML_MODEL getPMMLModelType() {
        logger.trace("getPMMLModelType");
        return PMML_MODEL.TREE_MODEL;
    }

    public KiePMMLTreeModel getKiePMMLModel(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, TreeModel model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModel {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        return KiePMMLTreeModelFactory.getKiePMMLTreeModel(fields, transformationDictionary, model, packageName, hasClassloader);
    }

    public KiePMMLTreeModel getKiePMMLModelWithSources(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, TreeModel model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSources {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        try {
            Map<String, String> sourcesMap = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap(fields, transformationDictionary, model, packageName);
            return new KiePMMLTreeModelWithSources(model.getModelName(), packageName, sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }
}

