/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.github;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.github.GithubAuth;
import org.jbpm.process.workitem.github.RepositoryInfo;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Wid(widfile="GithubListRepositories.wid", name="GithubListRepositories", displayName="GithubListRepositories", defaultHandler="mvel: new org.jbpm.process.workitem.github.ListRepositoriesWorkitemHandler(\"userName\", \"password\")", documentation="github-workitem/index.html", category="github-workitem", icon="GithubListRepositories.png", parameters={@WidParameter(name="User", required=true)}, results={@WidResult(name="RepoListInfo", runtimeType="java.util.List")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="github-workitem", version="7.60.0.Final")}, serviceInfo=@WidService(category="Github", description="Create Gist or list your repositories in Github", keywords="github,repo,repository,list", action=@WidAction(title="List all GitHub repositories"), authinfo=@WidAuth(required=true, params={"userName", "password"}, paramsdescription={"Github username", "Github password"}, referencesite="https://github.com/")))
public class ListRepositoriesWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private String userName;
    private String password;
    private GithubAuth auth = new GithubAuth();
    private static final Logger logger = LoggerFactory.getLogger(ListRepositoriesWorkitemHandler.class);
    private static final String RESULTS_VALUE = "RepoListInfo";

    public ListRepositoriesWorkitemHandler(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            HashMap results = new HashMap();
            String user = (String)workItem.getParameter("User");
            RepositoryService repoService = this.auth.getRespositoryService(this.userName, this.password);
            List userRepos = repoService.getRepositories(user);
            ArrayList<RepositoryInfo> resultRepositoryInformation = new ArrayList<RepositoryInfo>();
            if (userRepos != null) {
                for (Repository repo : userRepos) {
                    resultRepositoryInformation.add(new RepositoryInfo(repo));
                }
            } else {
                logger.info("No repositories found for " + user);
            }
            results.put(RESULTS_VALUE, resultRepositoryInformation);
            workItemManager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(GithubAuth auth) {
        this.auth = auth;
    }
}

