/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.io.impl.DescrResource;
import org.drools.core.util.StringUtils;
import org.drools.modelcompiler.builder.GeneratedFile;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.PackageSources;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KieDescr;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.kie.dependencies.HasKnowledgeBuilder;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsModelProvider<T extends Model, E extends KiePMMLDroolsModel>
implements ModelImplementationProvider<T, E> {
    private static final Logger logger = LoggerFactory.getLogger((String)DroolsModelProvider.class.getName());

    public E getKiePMMLModel(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModel {} {} {}", new Object[]{packageName, fields, model});
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)hasClassloader;
        KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(fields, model, fieldTypeMap);
        E toReturn = this.getKiePMMLDroolsModel(fields, transformationDictionary, model, fieldTypeMap, packageName, hasClassloader);
        PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, ((KiePMMLDroolsModel)((Object)toReturn)).getKModulePackageName());
        CompositePackageDescr compositePackageDescr = new CompositePackageDescr(null, packageDescr);
        knowledgeBuilder.buildPackages(Collections.singletonList(compositePackageDescr));
        return toReturn;
    }

    public E getKiePMMLModelWithSources(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSources {} {} {}", new Object[]{fields, model, hasClassloader});
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        try {
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(fields, model, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(fields, transformationDictionary, model, fieldTypeMap, packageName);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, packageName);
            HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)hasClassloader;
            KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
            String pkgUUID = StringUtils.getPkgUUID((ReleaseId)knowledgeBuilder.getReleaseId(), (String)packageName);
            packageDescr.setPreferredPkgUUID(pkgUUID);
            Map<String, String> rulesSourceMap = Collections.unmodifiableMap(this.getRulesSourceMap(packageDescr));
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(model.getModelName(), packageName, pkgUUID, sourcesMap, rulesSourceMap);
            knowledgeBuilder.registerPackage(packageDescr);
            return (E)((Object)toReturn);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public E getKiePMMLModelWithSourcesCompiled(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSourcesCompiled {} {} {}", new Object[]{fields, model, hasClassloader});
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        try {
            HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)hasClassloader;
            KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(fields, model, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(fields, transformationDictionary, model, fieldTypeMap, packageName);
            String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
            String fullClassName = packageName + "." + className;
            hasClassloader.compileAndLoadClass(sourcesMap, fullClassName);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, packageName);
            String pkgUUID = StringUtils.getPkgUUID((ReleaseId)knowledgeBuilder.getReleaseId(), (String)packageName);
            packageDescr.setPreferredPkgUUID(pkgUUID);
            Map<String, String> rulesSourceMap = Collections.unmodifiableMap(this.getRulesSourceMap(packageDescr));
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(model.getModelName(), packageName, pkgUUID, sourcesMap, rulesSourceMap);
            CompositePackageDescr compositePackageDescr = new CompositePackageDescr(null, packageDescr);
            knowledgeBuilder.buildPackages(Collections.singletonList(compositePackageDescr));
            return (E)((Object)toReturn);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public PackageDescr getPackageDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        return KiePMMLDescrFactory.getBaseDescr(kiePMMLDroolsAST, packageName);
    }

    public abstract E getKiePMMLDroolsModel(List<Field<?>> var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4, String var5, HasClassLoader var6);

    public abstract KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> var1, T var2, Map<String, KiePMMLOriginalTypeGeneratedType> var3, List<KiePMMLDroolsType> var4);

    public abstract Map<String, String> getKiePMMLDroolsModelSourcesMap(List<Field<?>> var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4, String var5) throws IOException;

    protected KiePMMLDroolsAST getKiePMMLDroolsASTCommon(List<Field<?>> fields, T model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        List<KiePMMLDroolsType> types = fieldTypeMap.values().stream().map(kiePMMLOriginalTypeGeneratedType -> {
            String type = DATA_TYPE.byName((String)kiePMMLOriginalTypeGeneratedType.getOriginalType()).getMappedClass().getSimpleName();
            return new KiePMMLDroolsType(kiePMMLOriginalTypeGeneratedType.getGeneratedType(), type);
        }).collect(Collectors.toList());
        types.addAll(KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields));
        return this.getKiePMMLDroolsAST(fields, model, fieldTypeMap, types);
    }

    protected Map<String, String> getRulesSourceMap(PackageDescr packageDescr) {
        List<GeneratedFile> generatedRuleFiles = this.generateRulesFiles(packageDescr);
        return generatedRuleFiles.stream().collect(Collectors.toMap(generatedFile -> generatedFile.getPath().replace(File.separatorChar, '.').replace('/', '.').replace(".java", ""), generatedFile -> new String(generatedFile.getData())));
    }

    protected List<GeneratedFile> generateRulesFiles(PackageDescr packageDescr) {
        ModelBuilderImpl modelBuilder = new ModelBuilderImpl(PackageSources::dumpSources, new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{this.getClass().getClassLoader()}), (ReleaseId)new ReleaseIdImpl("dummy:dummy:0.0.0"), false);
        CompositeKnowledgeBuilder batch = modelBuilder.batch();
        batch.add((Resource)new DescrResource((KieDescr)packageDescr), ResourceType.DESCR);
        try {
            batch.build();
            if (modelBuilder.hasErrors()) {
                StringBuilder builder = new StringBuilder();
                for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                    logger.error(error.toString());
                    builder.append(error.toString()).append(" ");
                }
                throw new KiePMMLException(builder.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            StringBuilder builder = new StringBuilder(e.getMessage()).append(" ");
            for (DroolsError error : modelBuilder.getErrors().getErrors()) {
                logger.error(error.toString());
                builder.append(error.toString()).append(" ");
            }
            throw new RuntimeException(builder.toString(), e);
        }
        return this.generateModels((ModelBuilderImpl<PackageSources>)modelBuilder).stream().map(f -> new GeneratedFile(GeneratedFile.Type.RULE, f.getPath(), new String(f.getData()))).collect(Collectors.toList());
    }

    protected List<GeneratedFile> generateModels(ModelBuilderImpl<PackageSources> modelBuilder) {
        ArrayList<GeneratedFile> toReturn = new ArrayList<GeneratedFile>();
        for (PackageSources pkgSources : modelBuilder.getPackageSources()) {
            pkgSources.collectGeneratedFiles(toReturn);
        }
        return toReturn;
    }
}

