/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.twitter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.jbpm.document.Document;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.twitter.TwitterAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.StatusUpdate;
import twitter4j.Twitter;

@Wid(widfile="TwitterUpdateStatus.wid", name="TwitterUpdateStatus", displayName="TwitterUpdateStatus", defaultHandler="mvel: new org.jbpm.process.workitem.twitter.UpdateStatusWorkitemHandler(\"consumerKey\", \"consumerSecret\", \"accessKey\", \"accessSecret\")", documentation="twitter-workitem/index.html", category="twitter-workitem", icon="TwitterUpdateStatus.png", parameters={@WidParameter(name="StatusUpdate", required=true), @WidParameter(name="Media", runtimeType="org.jbpm.document.Document"), @WidParameter(name="DebugEnabled")}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="twitter-workitem", version="7.60.0.Final")}, serviceInfo=@WidService(category="Twitter", description="Update status and send messages using Twitter", keywords="twitter,tweet,update,status,message", action=@WidAction(title="Update your Twitter status"), authinfo=@WidAuth(required=true, params={"consumerKey", "consumerSecret", "accessKey", "accessSecret"}, paramsdescription={"Twitter consumer key", "Twitter consumer secret", "Twitter access key", "Twitter access secret"}, referencesite="https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens.html")))
public class UpdateStatusWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateStatusWorkitemHandler.class);
    private TwitterAuth auth = new TwitterAuth();
    private String consumerKey;
    private String consumerSecret;
    private String accessKey;
    private String accessSecret;
    private StatusUpdate statusUpdate;

    public UpdateStatusWorkitemHandler(String consumerKey, String consumerSecret, String accessKey, String accessSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String statusMessage = (String)workItem.getParameter("StatusUpdate");
            Document statusMedia = null;
            if (workItem.getParameter("Media") != null) {
                statusMedia = (Document)workItem.getParameter("Media");
            }
            boolean debugOption = false;
            if (workItem.getParameter("DebugEnabled") != null) {
                debugOption = Boolean.parseBoolean((String)workItem.getParameter("DebugEnabled"));
            }
            Twitter twitter = this.auth.getTwitterService(this.consumerKey, this.consumerSecret, this.accessKey, this.accessSecret, debugOption);
            this.statusUpdate = new StatusUpdate(statusMessage);
            if (statusMedia != null) {
                this.statusUpdate.setMedia(FilenameUtils.getBaseName((String)statusMedia.getName()) + "." + FilenameUtils.getExtension((String)statusMedia.getName()), (InputStream)new ByteArrayInputStream(statusMedia.getContent()));
            }
            twitter.updateStatus(this.statusUpdate);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }

    public void setAuth(TwitterAuth auth) {
        this.auth = auth;
    }

    public StatusUpdate getStatusUpdate() {
        return this.statusUpdate;
    }
}

