/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.proto.schema;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Field;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Message;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;

public class SchemaGenerator {
    private static final char NEW_LINE = '\n';

    public String generate(Schema schema) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("package ").append(schema.getPkg()).append(";\n");
        stringBuilder.append(this.buildMessages(schema.getMessages()));
        return stringBuilder.toString();
    }

    private String buildMessages(Set<Message> messages) {
        StringBuilder stringBuilder = new StringBuilder();
        if (messages == null) {
            return "";
        }
        messages.stream().map(this::buildMessage).sorted().forEachOrdered(message -> {
            stringBuilder.append((String)message);
            stringBuilder.append('\n');
        });
        return stringBuilder.toString();
    }

    protected String buildMessage(Message message) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/**\n  * @Indexed\n  */\n");
        stringBuilder.append("message");
        stringBuilder.append(" ");
        stringBuilder.append(message.getName());
        stringBuilder.append(" {");
        stringBuilder.append('\n');
        message.getFields().stream().sorted(Comparator.comparingInt(Field::getIndex)).map(this::buildField).forEachOrdered(field -> {
            stringBuilder.append((String)field);
            stringBuilder.append('\n');
        });
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected String buildField(Field field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.buildIndex(field));
        stringBuilder.append(field.getScope().toString().toLowerCase());
        stringBuilder.append(" ");
        stringBuilder.append(field.getType());
        stringBuilder.append(" ");
        stringBuilder.append(field.getName());
        stringBuilder.append(" = ");
        stringBuilder.append(field.getIndex());
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    private String buildIndex(Field field) {
        return MessageFormat.format("/* @Field(index=Index.YES, analyze = Analyze.{0}, store = Store.YES) {1} {2}*/", this.getYesNo(field.isSearchable()), this.getSortable(field), this.getAnalyzer(field));
    }

    private String getSortable(Field field) {
        if (field.isSortable().booleanValue()) {
            return "@SortableField";
        }
        return "";
    }

    private String getYesNo(boolean bool) {
        return bool ? "YES" : "NO";
    }

    private String getAnalyzer(Field field) {
        if (!field.isSearchable().booleanValue()) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)field.getAnalyzer())) {
            return "@Analyzer(definition=\"standard\")";
        }
        return MessageFormat.format("@Analyzer(definition=\"{0}\")", field.getAnalyzer());
    }
}

