/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.dmg.pmml.Field;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLTarget;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.api.provider.ModelImplementationProviderFinder;
import org.kie.pmml.compiler.commons.implementations.ModelImplementationProviderFinderImpl;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLModelRetriever {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLModelRetriever.class.getName());
    private static final ModelImplementationProviderFinder modelImplementationProviderFinder = new ModelImplementationProviderFinderImpl();

    private KiePMMLModelRetriever() {
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModel(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Model model, HasClassLoader hasClassloader) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModel {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        String modelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName()));
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(implementation -> implementation.getKiePMMLModel(modelPackageName, fields, transformationDictionary, model, hasClassloader)).map(kiePMMLModel -> KiePMMLModelRetriever.getPopulatedWithPMMLModelFields(kiePMMLModel, fields, model.getMiningSchema(), model.getOutput())).map(kiePMMLModel -> KiePMMLModelRetriever.getPopulatedWithKiePMMLTargets(kiePMMLModel, model.getTargets())).findFirst();
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSources(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Model model, HasClassLoader hasClassloader) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSources {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        String modelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName()));
        Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction = implementation -> implementation.getKiePMMLModelWithSources(modelPackageName, fields, transformationDictionary, model, hasClassloader);
        return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(fields, model, modelFunction);
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Model model, HasClassLoader hasClassloader) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        String modelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName()));
        Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction = implementation -> implementation.getKiePMMLModelWithSourcesCompiled(modelPackageName, fields, transformationDictionary, model, hasClassloader);
        return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(fields, model, modelFunction);
    }

    static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon(List<Field<?>> fields, Model model, Function<ModelImplementationProvider<Model, KiePMMLModel>, KiePMMLModel> modelFunction) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCommon {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(modelFunction).map(kiePMMLModel -> KiePMMLModelRetriever.getPopulatedWithPMMLModelFields(kiePMMLModel, fields, model.getMiningSchema(), model.getOutput())).findFirst();
    }

    static KiePMMLModel getPopulatedWithPMMLModelFields(KiePMMLModel toPopulate, List<Field<?>> fields, MiningSchema miningSchema, Output output) {
        List<MiningField> converted;
        if (miningSchema != null) {
            converted = ModelUtils.convertToKieMiningFieldList(miningSchema, fields);
            toPopulate.setMiningFields(converted);
        }
        if (output != null) {
            converted = ModelUtils.convertToKieOutputFieldList(output, fields);
            toPopulate.setOutputFields(converted);
        }
        return toPopulate;
    }

    static KiePMMLModel getPopulatedWithKiePMMLTargets(KiePMMLModel toPopulate, Targets targets) {
        if (targets != null) {
            List<KiePMMLTarget> converted = ModelUtils.convertToKiePMMLTargetList(targets);
            toPopulate.setKiePMMLTargets(converted);
        }
        return toPopulate;
    }

    private static Stream<ModelImplementationProvider<Model, KiePMMLModel>> getModelImplementationProviderStream(Model model) {
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        return modelImplementationProviderFinder.getImplementations(false).stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType()));
    }
}

