/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.executor;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.clustering.ClusteringModel;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.clustering.compiler.factories.KiePMMLClusteringModelFactory;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModelWithSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringModelImplementationProvider
implements ModelImplementationProvider<ClusteringModel, KiePMMLClusteringModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusteringModelImplementationProvider.class.getName());

    public PMML_MODEL getPMMLModelType() {
        logger.trace("getPMMLModelType");
        return PMML_MODEL.CLUSTERING_MODEL;
    }

    public KiePMMLClusteringModel getKiePMMLModel(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, ClusteringModel model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModel {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        return KiePMMLClusteringModelFactory.getKiePMMLClusteringModel(fields, transformationDictionary, model, packageName, hasClassloader);
    }

    public KiePMMLClusteringModel getKiePMMLModelWithSources(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, ClusteringModel model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSources {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        try {
            Map<String, String> sourcesMap = KiePMMLClusteringModelFactory.getKiePMMLClusteringModelSourcesMap(fields, transformationDictionary, model, packageName);
            return new KiePMMLClusteringModelWithSources(model.getModelName(), packageName, sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }
}

