/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;

public class DataModelUtils {
    public static boolean isAssignable(ObjectProperty property) {
        return property != null && !property.isFinal() && !property.isStatic();
    }

    public static boolean isKeyField(ObjectProperty property) {
        return property != null && property.getAnnotation(Key.class.getName()) != null;
    }

    public static boolean isPositionField(ObjectProperty property) {
        return property != null && property.getAnnotation(Position.class.getName()) != null;
    }

    public static int keyFieldsCount(DataObject dataObject) {
        int result = 0;
        for (ObjectProperty property : dataObject.getProperties()) {
            if (!DataModelUtils.isKeyField(property)) continue;
            ++result;
        }
        return result;
    }

    public static List<ObjectProperty> filterAssignableFields(List<ObjectProperty> properties) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        if (properties != null) {
            for (ObjectProperty property : properties) {
                if (!DataModelUtils.isAssignable(property)) continue;
                result.add(property);
            }
        }
        return result;
    }

    public static List<ObjectProperty> filterAssignableFields(DataObject dataObject) {
        List<ObjectProperty> result = new ArrayList<ObjectProperty>();
        if (dataObject.getProperties() != null && dataObject.getProperties().size() > 0) {
            result.addAll(dataObject.getProperties());
            result = DataModelUtils.filterAssignableFields(result);
        }
        return result;
    }

    public static List<ObjectProperty> filterKeyFields(List<ObjectProperty> properties) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        for (ObjectProperty property : DataModelUtils.filterAssignableFields(properties)) {
            if (!DataModelUtils.isKeyField(property)) continue;
            result.add(property);
        }
        return result;
    }

    public static List<ObjectProperty> filterKeyFields(DataObject dataObject) {
        List<ObjectProperty> result = new ArrayList<ObjectProperty>();
        if (dataObject.getProperties() != null && dataObject.getProperties().size() > 0) {
            result.addAll(dataObject.getProperties());
            result = DataModelUtils.filterKeyFields(result);
        }
        return result;
    }

    public static List<ObjectProperty> filterPositionFields(List<ObjectProperty> properties) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        for (ObjectProperty property : DataModelUtils.filterAssignableFields(properties)) {
            if (!DataModelUtils.isPositionField(property)) continue;
            result.add(property);
        }
        return result;
    }

    public static List<ObjectProperty> filterPositionFields(DataObject dataObject) {
        List<ObjectProperty> result = new ArrayList<ObjectProperty>();
        if (dataObject.getProperties() != null && dataObject.getProperties().size() > 0) {
            result.addAll(dataObject.getProperties());
            result = DataModelUtils.filterPositionFields(result);
        }
        return result;
    }

    public static boolean equalsByFieldName(List<ObjectProperty> fields1, List<ObjectProperty> fields2) {
        if (fields1 == null) {
            return fields2 == null;
        }
        if (fields2 == null) {
            return false;
        }
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            if (fields1.get(i).getName().equals(fields2.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsByFieldType(List<ObjectProperty> fields1, List<ObjectProperty> fields2) {
        if (fields1 == null) {
            return fields2 == null;
        }
        if (fields2 == null) {
            return false;
        }
        if (fields1.size() != fields2.size()) {
            return false;
        }
        for (int i = 0; i < fields1.size(); ++i) {
            ObjectProperty field1 = fields1.get(i);
            ObjectProperty field2 = fields2.get(i);
            if (!Objects.equals(field1.getClassName(), field2.getClassName())) {
                return false;
            }
            if (field1.isMultiple() != field2.isMultiple()) {
                return false;
            }
            if (Objects.equals(field1.getBag(), field2.getBag())) continue;
            return false;
        }
        return true;
    }

    public static int positionFieldsCount(DataObject dataObject) {
        int result = 0;
        for (ObjectProperty property : dataObject.getProperties()) {
            if (!DataModelUtils.isPositionField(property)) continue;
            ++result;
        }
        return result;
    }

    public static int assignableFieldsCount(DataObject dataObject) {
        int result = 0;
        for (ObjectProperty property : dataObject.getProperties()) {
            if (!DataModelUtils.isAssignable(property)) continue;
            ++result;
        }
        return result;
    }

    public static List<ObjectProperty> sortByPosition(List<ObjectProperty> properties) {
        Collections.sort(properties, new Comparator<ObjectProperty>(){

            @Override
            public int compare(ObjectProperty o1, ObjectProperty o2) {
                Annotation position2;
                Object value;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                Integer key1 = null;
                Integer key2 = null;
                Annotation position1 = o1.getAnnotation(Position.class.getName());
                if (position1 != null) {
                    try {
                        value = position1.getValue("value");
                        key1 = value != null ? new Integer(value.toString()) : null;
                    }
                    catch (NumberFormatException e) {
                        key1 = null;
                    }
                }
                if ((position2 = o2.getAnnotation(Position.class.getName())) != null) {
                    try {
                        value = position2.getValue("value");
                        key2 = value != null ? new Integer(value.toString()) : null;
                    }
                    catch (NumberFormatException e) {
                        key2 = null;
                    }
                }
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                if (key1 == null && key2 != null) {
                    return -1;
                }
                return 1;
            }
        });
        return properties;
    }

    public static List<ObjectProperty> sortByFileOrder(List<ObjectProperty> properties) {
        Collections.sort(properties, new Comparator<ObjectProperty>(){

            @Override
            public int compare(ObjectProperty o1, ObjectProperty o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                Integer key1 = null;
                Integer key2 = null;
                int ikey1 = ((ObjectPropertyImpl)o1).getFileOrder();
                int ikey2 = ((ObjectPropertyImpl)o2).getFileOrder();
                key1 = ikey1 >= 0 ? Integer.valueOf(ikey1) : null;
                Integer n = key2 = ikey2 >= 0 ? Integer.valueOf(ikey2) : null;
                if (key1 == null && key2 == null) {
                    return 0;
                }
                if (key1 != null && key2 != null) {
                    return key1.compareTo(key2);
                }
                if (key1 == null && key2 != null) {
                    return -1;
                }
                return 1;
            }
        });
        return properties;
    }
}

