/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.WildcardMatcher;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.utils.ArrayUtil;

public class MockClassLoaderConfiguration {
    static final String[] PACKAGES_TO_BE_DEFERRED = new String[]{"org.hamcrest.*", "jdk.*", "java.*", "javax.accessibility.*", "sun.*", "org.junit.*", "org.testng.*", "junit.*", "org.pitest.*", "org.powermock.modules.junit4.common.internal.*", "org.powermock.modules.junit3.internal.PowerMockJUnit3RunnerDelegate*", "org.powermock.core*", "org.jacoco.agent.rt.*"};
    private static final String[] PACKAGES_TO_LOAD_BUT_NOT_MODIFY = new String[]{"org.junit.", "junit.", "org.testng.", "org.easymock.", "net.sf.cglib.", "javassist.", "org.powermock.modules.junit4.internal.", "org.powermock.modules.junit4.legacy.internal.", "org.powermock.modules.junit3.internal.", "org.powermock"};
    private final String[] specificClassesToLoadButNotModify = new String[]{InvocationSubstitute.class.getName(), PowerMockPolicy.class.getName(), ClassReplicaCreator.class.getName()};
    private final Set<String> modify = Collections.synchronizedSet(new HashSet());
    private String[] deferPackages;

    public MockClassLoaderConfiguration() {
        this(new String[0], new String[0]);
    }

    public MockClassLoaderConfiguration(String[] classesToMock, String[] packagesToDefer) {
        this.deferPackages = MockClassLoaderConfiguration.getPackagesToDefer(packagesToDefer);
        this.addClassesToModify(classesToMock);
    }

    public void addIgnorePackage(String ... packagesToIgnore) {
        if (packagesToIgnore != null && packagesToIgnore.length > 0) {
            int previousLength = this.deferPackages.length;
            String[] newDeferPackages = new String[previousLength + packagesToIgnore.length];
            System.arraycopy(this.deferPackages, 0, newDeferPackages, 0, previousLength);
            System.arraycopy(packagesToIgnore, 0, newDeferPackages, previousLength, packagesToIgnore.length);
            this.deferPackages = newDeferPackages;
        }
    }

    public final void addClassesToModify(String ... classes) {
        if (classes != null) {
            for (String clazz : classes) {
                if (this.shouldDefer(PACKAGES_TO_BE_DEFERRED, clazz)) continue;
                this.modify.add(clazz);
            }
        }
    }

    boolean shouldDefer(String className) {
        return this.shouldDefer(this.deferPackages, className);
    }

    boolean shouldMockClass(String className) {
        return this.shouldModify(className) && !this.shouldLoadWithMockClassloaderWithoutModifications(className);
    }

    String[] getDeferPackages() {
        return ArrayUtil.clone(this.deferPackages);
    }

    private boolean shouldDefer(String[] packages, String name) {
        for (String packageToCheck : packages) {
            if (!this.deferConditionMatches(name, packageToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean deferConditionMatches(String name, String packageName) {
        boolean wildcardMatch = WildcardMatcher.matches(name, packageName);
        return wildcardMatch && !this.shouldLoadUnmodifiedClass(name) && !this.shouldModifyClass(name);
    }

    private boolean shouldIgnore(String[] packages, String name) {
        for (String ignore : packages) {
            if (!WildcardMatcher.matches(name, ignore)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldLoadUnmodifiedClass(String className) {
        for (String classNameToLoadButNotModify : this.specificClassesToLoadButNotModify) {
            if (!className.equals(classNameToLoadButNotModify)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldLoadWithMockClassloaderWithoutModifications(String className) {
        if (className.startsWith("org.powermock.example")) {
            return false;
        }
        for (String packageToLoadButNotModify : PACKAGES_TO_LOAD_BUT_NOT_MODIFY) {
            if (!className.startsWith(packageToLoadButNotModify)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldModifyClass(String className) {
        return this.modify.contains(className);
    }

    private boolean shouldIgnore(String className) {
        return this.shouldIgnore(this.deferPackages, className);
    }

    boolean shouldModify(String className) {
        boolean shouldIgnoreClass = this.shouldIgnore(className);
        boolean shouldModifyAll = this.shouldModifyAll();
        if (shouldModifyAll) {
            return !shouldIgnoreClass;
        }
        return WildcardMatcher.matchesAny(this.modify, className);
    }

    private boolean shouldModifyAll() {
        return this.modify.size() == 1 && this.modify.iterator().next().equals("*");
    }

    private static String[] getPackagesToDefer(String[] additionalDeferPackages) {
        int additionalIgnorePackagesLength = additionalDeferPackages == null ? 0 : additionalDeferPackages.length;
        int defaultDeferPackagesLength = PACKAGES_TO_BE_DEFERRED.length;
        int allIgnoreLength = defaultDeferPackagesLength + additionalIgnorePackagesLength;
        String[] allPackagesToBeIgnored = new String[allIgnoreLength];
        if (allIgnoreLength > defaultDeferPackagesLength) {
            System.arraycopy(PACKAGES_TO_BE_DEFERRED, 0, allPackagesToBeIgnored, 0, defaultDeferPackagesLength);
            System.arraycopy(additionalDeferPackages != null ? additionalDeferPackages : new String[]{}, 0, allPackagesToBeIgnored, defaultDeferPackagesLength, additionalIgnorePackagesLength);
            return allPackagesToBeIgnored;
        }
        return PACKAGES_TO_BE_DEFERRED;
    }
}

