/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.events.IntermediateCatchEventConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CatchEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.BaseCatchingIntermediateEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateCompensationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateConditionalEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateErrorEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateLinkEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateMessageEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.CircleDimensionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.conditional.CancellingConditionalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.error.CancellingErrorEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.CancellingEscalationEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.link.LinkEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.message.CancellingMessageEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.timer.CancellingTimerEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingRequest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class IntermediateCatchEventConverterTest {
    private static final String UUID = "CATCH EVENT UUID";
    private TypedFactoryManager factoryManager;
    private PropertyReaderFactory propertyReaderFactory;
    private CatchEventPropertyReader propertyReader;
    private View view;
    private List<EventDefinition> eventDefinitions;
    private IntermediateCatchEventConverter tested;

    @Before
    public void setUp() {
        this.factoryManager = (TypedFactoryManager)Mockito.mock(TypedFactoryManager.class);
        this.propertyReaderFactory = (PropertyReaderFactory)Mockito.mock(PropertyReaderFactory.class);
        this.propertyReader = (CatchEventPropertyReader)Mockito.mock(CatchEventPropertyReader.class);
        this.eventDefinitions = new ArrayList<EventDefinition>();
        Mockito.when((Object)this.propertyReader.getEventDefinitions()).thenReturn(this.eventDefinitions);
        Mockito.when((Object)this.propertyReaderFactory.of((CatchEvent)Mockito.any())).thenReturn((Object)this.propertyReader);
        this.view = (View)Mockito.mock(View.class);
        this.tested = (IntermediateCatchEventConverter)Mockito.spy((Object)new IntermediateCatchEventConverter(this.factoryManager, this.propertyReaderFactory, MarshallingRequest.Mode.IGNORE));
    }

    @Test
    public void constructor() {
        Assert.assertEquals((Object)this.factoryManager, (Object)this.tested.factoryManager);
        Assert.assertEquals((Object)this.propertyReaderFactory, (Object)this.tested.propertyReaderFactory);
    }

    @Test
    public void convert() {
        this.eventDefinitions.clear();
        try {
            this.tested.convert((IntermediateCatchEvent)Mockito.any());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"An intermediate catch event should contain exactly one definition", (Object)exception.getMessage());
        }
        this.verifyErrorEventConvert();
        this.verifySignalEventConvert();
        this.verifyLinkEventConvert();
        this.verifyTimerEventConvert();
        this.verifyMessageEventConvert();
        this.verifyConditionalEventConvert();
        this.verifyEscalationEventConvert();
        this.verifyCompensationEventConvert();
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        try {
            this.tested.convert((IntermediateCatchEvent)Mockito.any());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"Multiple definitions not supported for intermediate catch event", (Object)exception.getMessage());
        }
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader, (VerificationMode)Mockito.times((int)10))).getEventDefinitions();
    }

    @Test
    public void convertBoundaryEvent() {
        this.eventDefinitions.clear();
        try {
            this.tested.convertBoundaryEvent((BoundaryEvent)ArgumentMatchers.any(BoundaryEvent.class));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"A boundary event should contain exactly one definition", (Object)exception.getMessage());
        }
        this.verifyBoundaryErrorEventConvert();
        this.verifyBoundarySignalEventConvert();
        this.verifyBoundaryTimerEventConvert();
        this.verifyBoundaryMessageEventConvert();
        this.verifyBoundaryConditionalEventConvert();
        this.verifyBoundaryEscalationEventConvert();
        this.verifyBoundaryCompensationEventConvert();
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        this.eventDefinitions.add((EventDefinition)Mockito.mock(EventDefinition.class));
        try {
            this.tested.convertBoundaryEvent((BoundaryEvent)ArgumentMatchers.any(BoundaryEvent.class));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)(exception instanceof UnsupportedOperationException));
            Assert.assertEquals((Object)"Multiple definitions not supported for boundary event", (Object)exception.getMessage());
        }
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader, (VerificationMode)Mockito.times((int)9))).getEventDefinitions();
    }

    @Test
    public void errorEvent() {
        IntermediateErrorEventCatching definition = (IntermediateErrorEventCatching)Mockito.mock(IntermediateErrorEventCatching.class);
        ErrorEventDefinition eventDefinition = (ErrorEventDefinition)Mockito.mock(ErrorEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.errorEvent((CatchEvent)catchEvent, eventDefinition);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((ErrorEventDefinition)Mockito.verify((Object)eventDefinition)).getErrorRef();
        ((IntermediateErrorEventCatching)Mockito.verify((Object)definition)).setExecutionSet((CancellingErrorEventExecutionSet)Mockito.any());
    }

    @Test
    public void signalEvent() {
        IntermediateSignalEventCatching definition = (IntermediateSignalEventCatching)Mockito.mock(IntermediateSignalEventCatching.class);
        SignalEventDefinition eventDefinition = (SignalEventDefinition)Mockito.mock(SignalEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.signalEvent((CatchEvent)catchEvent);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSignalRef();
        ((IntermediateSignalEventCatching)Mockito.verify((Object)definition)).setExecutionSet((CancellingSignalEventExecutionSet)Mockito.any());
    }

    @Test
    public void linkEvent() {
        IntermediateLinkEventCatching definition = (IntermediateLinkEventCatching)Mockito.mock(IntermediateLinkEventCatching.class);
        LinkEventDefinition eventDefinition = (LinkEventDefinition)Mockito.mock(LinkEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.linkEvent((CatchEvent)catchEvent);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getLinkRef();
        ((IntermediateLinkEventCatching)Mockito.verify((Object)definition)).setExecutionSet((LinkEventExecutionSet)Mockito.any());
    }

    @Test
    public void timerEvent() {
        IntermediateTimerEvent definition = (IntermediateTimerEvent)Mockito.mock(IntermediateTimerEvent.class);
        TimerEventDefinition eventDefinition = (TimerEventDefinition)Mockito.mock(TimerEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.timerEvent((CatchEvent)catchEvent, eventDefinition);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((TimerEventDefinition)Mockito.verify((Object)eventDefinition)).getTimeCycle();
        ((IntermediateTimerEvent)Mockito.verify((Object)definition)).setExecutionSet((CancellingTimerEventExecutionSet)Mockito.any());
    }

    @Test
    public void messageEvent() {
        IntermediateMessageEventCatching definition = (IntermediateMessageEventCatching)Mockito.mock(IntermediateMessageEventCatching.class);
        MessageEventDefinition eventDefinition = (MessageEventDefinition)Mockito.mock(MessageEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.messageEvent((CatchEvent)catchEvent, eventDefinition);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((MessageEventDefinition)Mockito.verify((Object)eventDefinition, (VerificationMode)Mockito.times((int)2))).getMessageRef();
        ((IntermediateMessageEventCatching)Mockito.verify((Object)definition)).setExecutionSet((CancellingMessageEventExecutionSet)Mockito.any());
    }

    @Test
    public void conditionalEvent() {
        IntermediateConditionalEvent definition = (IntermediateConditionalEvent)Mockito.mock(IntermediateConditionalEvent.class);
        ConditionalEventDefinition eventDefinition = (ConditionalEventDefinition)Mockito.mock(ConditionalEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.conditionalEvent((CatchEvent)catchEvent, eventDefinition);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((ConditionalEventDefinition)Mockito.verify((Object)eventDefinition)).getCondition();
        ((IntermediateConditionalEvent)Mockito.verify((Object)definition)).setExecutionSet((CancellingConditionalEventExecutionSet)Mockito.any());
    }

    @Test
    public void escalationEvent() {
        IntermediateEscalationEvent definition = (IntermediateEscalationEvent)Mockito.mock(IntermediateEscalationEvent.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)Mockito.mock(EscalationEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.escalationEvent((CatchEvent)catchEvent, eventDefinition);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).isCancelActivity();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((EscalationEventDefinition)Mockito.verify((Object)eventDefinition)).getEscalationRef();
        ((IntermediateEscalationEvent)Mockito.verify((Object)definition)).setExecutionSet((CancellingEscalationEventExecutionSet)Mockito.any());
    }

    @Test
    public void compensationEvent() {
        IntermediateCompensationEvent definition = (IntermediateCompensationEvent)Mockito.mock(IntermediateCompensationEvent.class);
        CompensateEventDefinition eventDefinition = (CompensateEventDefinition)Mockito.mock(CompensateEventDefinition.class);
        IntermediateCatchEvent catchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.tested.compensationEvent((CatchEvent)catchEvent);
        this.verifyCommonProperties((BaseCatchingIntermediateEvent)definition);
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getSlaDueDate();
        ((IntermediateCompensationEvent)Mockito.verify((Object)definition)).setExecutionSet((BaseCancellingEventExecutionSet)Mockito.any());
    }

    private void verifyErrorEventConvert() {
        IntermediateErrorEventCatching definition = (IntermediateErrorEventCatching)Mockito.mock(IntermediateErrorEventCatching.class);
        ErrorEventDefinition eventDefinition = (ErrorEventDefinition)Mockito.mock(ErrorEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).errorEvent((CatchEvent)intermediateCatchEvent, eventDefinition);
    }

    private void verifySignalEventConvert() {
        IntermediateSignalEventCatching definition = (IntermediateSignalEventCatching)Mockito.mock(IntermediateSignalEventCatching.class);
        SignalEventDefinition eventDefinition = (SignalEventDefinition)Mockito.mock(SignalEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).signalEvent((CatchEvent)intermediateCatchEvent);
    }

    private void verifyLinkEventConvert() {
        IntermediateLinkEventCatching definition = (IntermediateLinkEventCatching)Mockito.mock(IntermediateLinkEventCatching.class);
        LinkEventDefinition eventDefinition = (LinkEventDefinition)Mockito.mock(LinkEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).linkEvent((CatchEvent)intermediateCatchEvent);
    }

    private void verifyTimerEventConvert() {
        IntermediateTimerEvent definition = (IntermediateTimerEvent)Mockito.mock(IntermediateTimerEvent.class);
        TimerEventDefinition eventDefinition = (TimerEventDefinition)Mockito.mock(TimerEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).timerEvent((CatchEvent)intermediateCatchEvent, eventDefinition);
    }

    private void verifyMessageEventConvert() {
        IntermediateMessageEventCatching definition = (IntermediateMessageEventCatching)Mockito.mock(IntermediateMessageEventCatching.class);
        MessageEventDefinition eventDefinition = (MessageEventDefinition)Mockito.mock(MessageEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).messageEvent((CatchEvent)intermediateCatchEvent, eventDefinition);
    }

    private void verifyConditionalEventConvert() {
        IntermediateConditionalEvent definition = (IntermediateConditionalEvent)Mockito.mock(IntermediateConditionalEvent.class);
        ConditionalEventDefinition eventDefinition = (ConditionalEventDefinition)Mockito.mock(ConditionalEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).conditionalEvent((CatchEvent)intermediateCatchEvent, eventDefinition);
    }

    private void verifyEscalationEventConvert() {
        IntermediateEscalationEvent definition = (IntermediateEscalationEvent)Mockito.mock(IntermediateEscalationEvent.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)Mockito.mock(EscalationEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).escalationEvent((CatchEvent)intermediateCatchEvent, eventDefinition);
    }

    private void verifyCompensationEventConvert() {
        IntermediateCompensationEvent definition = (IntermediateCompensationEvent)Mockito.mock(IntermediateCompensationEvent.class);
        CompensateEventDefinition eventDefinition = (CompensateEventDefinition)Mockito.mock(CompensateEventDefinition.class);
        IntermediateCatchEvent intermediateCatchEvent = this.mockIntermediateCatchEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convert(intermediateCatchEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).compensationEvent((CatchEvent)intermediateCatchEvent);
    }

    private void verifyBoundaryErrorEventConvert() {
        IntermediateErrorEventCatching definition = (IntermediateErrorEventCatching)Mockito.mock(IntermediateErrorEventCatching.class);
        ErrorEventDefinition eventDefinition = (ErrorEventDefinition)Mockito.mock(ErrorEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).errorEvent((CatchEvent)boundaryEvent, eventDefinition);
    }

    private void verifyBoundarySignalEventConvert() {
        IntermediateSignalEventCatching definition = (IntermediateSignalEventCatching)Mockito.mock(IntermediateSignalEventCatching.class);
        SignalEventDefinition eventDefinition = (SignalEventDefinition)Mockito.mock(SignalEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).signalEvent((CatchEvent)boundaryEvent);
    }

    private void verifyBoundaryTimerEventConvert() {
        IntermediateTimerEvent definition = (IntermediateTimerEvent)Mockito.mock(IntermediateTimerEvent.class);
        TimerEventDefinition eventDefinition = (TimerEventDefinition)Mockito.mock(TimerEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).timerEvent((CatchEvent)boundaryEvent, eventDefinition);
    }

    private void verifyBoundaryMessageEventConvert() {
        IntermediateMessageEventCatching definition = (IntermediateMessageEventCatching)Mockito.mock(IntermediateMessageEventCatching.class);
        MessageEventDefinition eventDefinition = (MessageEventDefinition)Mockito.mock(MessageEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).messageEvent((CatchEvent)boundaryEvent, eventDefinition);
    }

    private void verifyBoundaryConditionalEventConvert() {
        IntermediateConditionalEvent definition = (IntermediateConditionalEvent)Mockito.mock(IntermediateConditionalEvent.class);
        ConditionalEventDefinition eventDefinition = (ConditionalEventDefinition)Mockito.mock(ConditionalEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).conditionalEvent((CatchEvent)boundaryEvent, eventDefinition);
    }

    private void verifyBoundaryEscalationEventConvert() {
        IntermediateEscalationEvent definition = (IntermediateEscalationEvent)Mockito.mock(IntermediateEscalationEvent.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)Mockito.mock(EscalationEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).escalationEvent((CatchEvent)boundaryEvent, eventDefinition);
    }

    private void verifyBoundaryCompensationEventConvert() {
        IntermediateCompensationEvent definition = (IntermediateCompensationEvent)Mockito.mock(IntermediateCompensationEvent.class);
        CompensateEventDefinition eventDefinition = (CompensateEventDefinition)Mockito.mock(CompensateEventDefinition.class);
        BoundaryEvent boundaryEvent = this.mockBoundaryEvent((BaseCatchingIntermediateEvent)definition);
        this.eventDefinitions.clear();
        this.eventDefinitions.add((EventDefinition)eventDefinition);
        this.tested.convertBoundaryEvent(boundaryEvent);
        ((IntermediateCatchEventConverter)Mockito.verify((Object)this.tested)).compensationEvent((CatchEvent)boundaryEvent);
    }

    private void verifyCommonProperties(BaseCatchingIntermediateEvent definition) {
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getBounds();
        ((View)Mockito.verify((Object)this.view)).setBounds((Bounds)Mockito.any());
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getName();
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getDocumentation();
        ((BaseCatchingIntermediateEvent)Mockito.verify((Object)definition)).setGeneral((BPMNGeneralSet)Mockito.any());
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getBackgroundSet();
        ((BaseCatchingIntermediateEvent)Mockito.verify((Object)definition)).setBackgroundSet((BackgroundSet)Mockito.any());
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getFontSet();
        ((BaseCatchingIntermediateEvent)Mockito.verify((Object)definition)).setFontSet((FontSet)Mockito.any());
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getCircleDimensionSet();
        ((BaseCatchingIntermediateEvent)Mockito.verify((Object)definition)).setDimensionsSet((CircleDimensionSet)Mockito.any());
        ((CatchEventPropertyReader)Mockito.verify((Object)this.propertyReader)).getAssignmentsInfo();
        ((BaseCatchingIntermediateEvent)Mockito.verify((Object)definition)).setDataIOSet((DataIOSet)Mockito.any());
    }

    private IntermediateCatchEvent mockIntermediateCatchEvent(BaseCatchingIntermediateEvent eventDefinition) {
        IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)Mockito.mock(IntermediateCatchEvent.class);
        Mockito.when((Object)intermediateCatchEvent.getId()).thenReturn((Object)UUID);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.eq((Object)UUID), (Class)ArgumentMatchers.any())).thenReturn((Object)node);
        Mockito.when((Object)node.getContent()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.getDefinition()).thenReturn((Object)eventDefinition);
        return intermediateCatchEvent;
    }

    private BoundaryEvent mockBoundaryEvent(BaseCatchingIntermediateEvent eventDefinition) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)Mockito.mock(BoundaryEvent.class);
        Mockito.when((Object)boundaryEvent.getId()).thenReturn((Object)UUID);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.factoryManager.newNode((String)ArgumentMatchers.eq((Object)UUID), (Class)ArgumentMatchers.any())).thenReturn((Object)node);
        Mockito.when((Object)node.getContent()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.getDefinition()).thenReturn((Object)eventDefinition);
        return boundaryEvent;
    }
}

