/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.workitem;

import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.BPMNTestDefinitionFactory;
import org.kie.workbench.common.stunner.bpmn.backend.BPMNDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.DataTypeCacheServer;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.Unmarshalling;
import org.kie.workbench.common.stunner.bpmn.workitem.CustomTask;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.core.StunnerTestingGraphAPI;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NoWIDCustomTaskResolutionTest {
    private StunnerTestingGraphAPI stunnerAPI;
    private XMLEncoderDiagramMetadataMarshaller xmlEncoder;
    private WorkItemDefinitionRegistry widRegistry;
    private WorkItemDefinitionLookupService widService;
    private BPMNDirectDiagramMarshaller tested;
    private Diagram<Graph, Metadata> diagram;
    private static final String PATH_DIAGRAM = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram";
    private static final String BPMN_CUSTOM_TASK = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/customTask.bpmn";
    private static final String CUSTOM_TASK_ID = "_50DA575F-2FD3-49D4-A301-52F107E30AC4";
    private static final String CUSTOM_TASK_NAME = "Email";
    private static final String CUSTOM_TASK_TYPE = "Email";
    private static final String ASSIGNMENTS = "|Body:String,From:String,Subject:String,To:String||Status:String|[din]Body=This+is+an+e-mail+body.,[din]From=anyemail%40test.com,[din]Subject=Test,[din]To=someone%40test.com,[dout]Email+check=Status";
    private static final String ON_ENTRY_SCRIPT = "java : System.out.Println(\"On entry!\");";
    private static final String ON_EXIT_SCRIPT = "java : System.out.Println(\"On exit!\");";
    @Mock
    private DataTypeCacheServer dataTypeCacheServer;

    @Before
    public void setup() throws Exception {
        this.widRegistry = new WorkItemDefinitionRegistry(){

            public Collection<WorkItemDefinition> items() {
                return Collections.EMPTY_LIST;
            }

            public WorkItemDefinition get(String name) {
                return null;
            }
        };
        this.widService = (WorkItemDefinitionLookupService)Mockito.mock(WorkItemDefinitionLookupService.class);
        Mockito.when((Object)this.widService.execute((Object)((Metadata)ArgumentMatchers.any(Metadata.class)))).thenReturn((Object)this.widRegistry.items());
        this.stunnerAPI = StunnerTestingGraphBackendAPI.build(BPMNDefinitionSet.class, (TypeDefinitionFactory)new BPMNTestDefinitionFactory(this.widRegistry));
        this.xmlEncoder = new XMLEncoderDiagramMetadataMarshaller();
        this.tested = new BPMNDirectDiagramMarshaller(this.xmlEncoder, this.stunnerAPI.getDefinitionManager(), this.stunnerAPI.getRuleManager(), this.widService, this.stunnerAPI.getFactoryManager(), this.stunnerAPI.commandFactory, this.stunnerAPI.commandManager, this.dataTypeCacheServer);
        this.diagram = Unmarshalling.unmarshall((DiagramMarshaller)this.tested, BPMN_CUSTOM_TASK);
    }

    @Test
    public void testNoWIDPreserveCustomTaskType() {
        Node customTaskNode = this.diagram.getGraph().getNode(CUSTOM_TASK_ID);
        View customTaskNodeContent = (View)customTaskNode.getContent();
        Assert.assertTrue((boolean)(customTaskNodeContent.getDefinition() instanceof CustomTask));
        CustomTask customTask = (CustomTask)customTaskNodeContent.getDefinition();
        Assert.assertEquals((Object)"Email", (Object)customTask.getTaskType().getRawType());
    }

    @Test
    public void testNoWIDPreserveProperties() {
        Node customTaskNode = this.diagram.getGraph().getNode(CUSTOM_TASK_ID);
        View customTaskNodeContent = (View)customTaskNode.getContent();
        CustomTask customTask = (CustomTask)customTaskNodeContent.getDefinition();
        Assert.assertTrue((boolean)customTask.getCategory().isEmpty());
        Assert.assertTrue((boolean)customTask.getDescription().isEmpty());
        Assert.assertEquals((Object)"Email", (Object)customTask.getName());
        Assert.assertEquals((Object)ASSIGNMENTS, (Object)customTask.getDataIOSet().getAssignmentsinfo().getValue());
        Assert.assertTrue((boolean)customTask.getExecutionSet().getAdHocAutostart().getValue());
        Assert.assertTrue((boolean)customTask.getExecutionSet().getIsAsync().getValue());
        Assert.assertEquals((Object)ON_ENTRY_SCRIPT, (Object)customTask.getExecutionSet().getOnEntryAction().getValue().toString());
        Assert.assertEquals((Object)ON_EXIT_SCRIPT, (Object)customTask.getExecutionSet().getOnExitAction().getValue().toString());
    }
}

