/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public abstract class XContentSettingsLoader
implements SettingsLoader {
    private final boolean allowNullValues;

    public abstract XContentType contentType();

    XContentSettingsLoader(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    @Override
    public Map<String, String> load(String source) throws IOException {
        try (XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(NamedXContentRegistry.EMPTY, source);){
            Map<String, String> map = this.load(parser);
            return map;
        }
    }

    @Override
    public Map<String, String> load(byte[] source) throws IOException {
        try (XContentParser parser = XContentFactory.xContent(this.contentType()).createParser(NamedXContentRegistry.EMPTY, source);){
            Map<String, String> map = this.load(parser);
            return map;
        }
    }

    public Map<String, String> load(XContentParser jp) throws IOException {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> settings = new HashMap<String, String>();
        ArrayList<String> path = new ArrayList<String>();
        XContentParser.Token token = jp.nextToken();
        if (token == null) {
            return settings;
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("malformed, expected settings to start with 'object', instead was [{}]", new Object[]{token});
        }
        this.serializeObject(settings, sb, path, jp, null);
        XContentParser.Token lastToken = null;
        try {
            while (!jp.isClosed() && (lastToken = jp.nextToken()) == null) {
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", (Throwable)e, jp.getTokenLocation().lineNumber, jp.getTokenLocation().columnNumber);
        }
        if (lastToken != null) {
            throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", jp.getTokenLocation().lineNumber, jp.getTokenLocation().columnNumber);
        }
        return settings;
    }

    private void serializeObject(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String objFieldName) throws IOException {
        XContentParser.Token token;
        if (objFieldName != null) {
            path.add(objFieldName);
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, currentFieldName);
                continue;
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                this.serializeValue(settings, sb, path, parser, currentFieldName, true);
                continue;
            }
            this.serializeValue(settings, sb, path, parser, currentFieldName, false);
        }
        if (objFieldName != null) {
            path.remove(path.size() - 1);
        }
    }

    private void serializeArray(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName) throws IOException {
        XContentParser.Token token;
        int counter = 0;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                this.serializeObject(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.serializeArray(settings, sb, path, parser, fieldName + '.' + counter++);
                continue;
            }
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                this.serializeValue(settings, sb, path, parser, fieldName + '.' + counter++, true);
                continue;
            }
            this.serializeValue(settings, sb, path, parser, fieldName + '.' + counter++, false);
        }
    }

    private void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, XContentParser parser, String fieldName, boolean isNull) throws IOException {
        String currentValue;
        sb.setLength(0);
        for (String pathEle : path) {
            sb.append(pathEle).append('.');
        }
        sb.append(fieldName);
        String key = sb.toString();
        String string = currentValue = isNull ? null : parser.text();
        if (settings.containsKey(key)) {
            throw new ElasticsearchParseException("duplicate settings key [{}] found at line number [{}], column number [{}], previous value [{}], current value [{}]", key, parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber, settings.get(key), currentValue);
        }
        if (currentValue == null && !this.allowNullValues) {
            throw new ElasticsearchParseException("null-valued setting found for key [{}] found at line number [{}], column number [{}]", key, parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber);
        }
        settings.put(key, currentValue);
    }
}

