/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.event.local.CommandExecutedEvent;
import org.kie.workbench.common.stunner.core.command.event.local.CommandUndoExecutedEvent;
import org.kie.workbench.common.stunner.core.command.event.local.IsCommandAllowedEvent;
import org.kie.workbench.common.stunner.core.command.exception.CommandException;
import org.kie.workbench.common.stunner.core.command.impl.CommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Dependent
public class GraphCommandManagerImpl
implements GraphCommandManager {
    private static Logger LOGGER = Logger.getLogger(GraphCommandManagerImpl.class.getName());
    private final CommandManager<GraphCommandExecutionContext, RuleViolation> commandManager = new CommandManagerImpl<GraphCommandExecutionContext, RuleViolation>();
    private final Event<IsCommandAllowedEvent> isCommandAllowedEvent;
    private final Event<CommandExecutedEvent> commandExecutedEvent;
    private final Event<CommandUndoExecutedEvent> commandUndoExecutedEvent;

    protected GraphCommandManagerImpl() {
        this(null, null, null);
    }

    @Inject
    public GraphCommandManagerImpl(Event<IsCommandAllowedEvent> isCommandAllowedEvent, Event<CommandExecutedEvent> commandExecutedEvent, Event<CommandUndoExecutedEvent> commandUndoExecutedEvent) {
        this.isCommandAllowedEvent = isCommandAllowedEvent;
        this.commandExecutedEvent = commandExecutedEvent;
        this.commandUndoExecutedEvent = commandUndoExecutedEvent;
    }

    public CommandResult<RuleViolation> allow(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        try {
            CommandResult result = this.commandManager.allow((Object)context, command);
            if (null != this.isCommandAllowedEvent) {
                this.isCommandAllowedEvent.fire((Object)new IsCommandAllowedEvent(command, result));
            }
            return result;
        }
        catch (CommandException e) {
            LOGGER.log(Level.SEVERE, "Error while executing graph command. Message [" + e.getMessage() + "].");
            return GraphCommandResultBuilder.failed();
        }
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        try {
            CommandResult result = this.commandManager.execute((Object)context, command);
            if (null != this.commandExecutedEvent) {
                this.commandExecutedEvent.fire((Object)new CommandExecutedEvent(command, result));
            }
            return result;
        }
        catch (CommandException e) {
            LOGGER.log(Level.SEVERE, "Error while checking allow for graph command. Message [" + e.getMessage() + "].");
            return GraphCommandResultBuilder.failed();
        }
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        CommandResult result = this.commandManager.undo((Object)context, command);
        if (null != this.commandUndoExecutedEvent) {
            CommandUndoExecutedEvent event = new CommandUndoExecutedEvent(command, result);
            this.commandUndoExecutedEvent.fire((Object)event);
        }
        return result;
    }
}

