/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.exception.BadCommandArgumentsException;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.DirectGraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommand;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public abstract class AbstractGraphCompositeCommand
extends AbstractCompositeCommand<GraphCommandExecutionContext, RuleViolation>
implements GraphCommand {
    protected abstract boolean delegateRulesContextToChildren();

    @Override
    protected CommandResult<RuleViolation> doUndo(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        return command.undo(this.delegateRulesContextToChildren() ? context : this.buildEmptyExecutionContext(context));
    }

    @Override
    protected CommandResult<RuleViolation> doExecute(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        return command.execute(this.delegateRulesContextToChildren() ? context : this.buildEmptyExecutionContext(context));
    }

    @Override
    protected CommandResult<RuleViolation> doAllow(GraphCommandExecutionContext context, Command<GraphCommandExecutionContext, RuleViolation> command) {
        return command.allow((Object)context);
    }

    protected MutableIndex<Node, Edge> getMutableIndex(GraphCommandExecutionContext context) {
        return (MutableIndex)context.getGraphIndex();
    }

    protected Graph<?, Node> getGraph(GraphCommandExecutionContext context) {
        return context.getGraphIndex().getGraph();
    }

    protected Node<?, Edge> getNode(GraphCommandExecutionContext context, String uuid) {
        return context.getGraphIndex().getNode(uuid);
    }

    protected Edge<? extends View, Node> getViewEdge(GraphCommandExecutionContext context, String uuid) {
        return context.getGraphIndex().getEdge(uuid);
    }

    protected Node<?, Edge> checkNodeNotNull(GraphCommandExecutionContext context, String uuid) {
        Node<?, Edge> e = this.getNode(context, uuid);
        if (null == e) {
            throw new BadCommandArgumentsException((Command)this, (Object)uuid, "Node not found for [" + uuid + "].");
        }
        return e;
    }

    private DirectGraphCommandExecutionContext buildEmptyExecutionContext(GraphCommandExecutionContext context) {
        return new DirectGraphCommandExecutionContext(context.getDefinitionManager(), context.getFactoryManager(), context.getGraphIndex());
    }
}

