/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.MiningModel;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentationFactory;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLMiningModelFactory {
    static final String SEGMENTATIONNAME_TEMPLATE = "%s_Segmentation";
    static final String KIE_PMML_MINING_MODEL_TEMPLATE_JAVA = "KiePMMLMiningModelTemplate.tmpl";
    static final String KIE_PMML_MINING_MODEL_TEMPLATE = "KiePMMLMiningModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLMiningModelFactory.class.getName());

    private KiePMMLMiningModelFactory() {
    }

    public static KiePMMLMiningModel getKiePMMLMiningModel(List<Field<?>> fields, TransformationDictionary transformationDictionary, MiningModel model, String packageName, HasClassLoader hasClassLoader) {
        logger.debug("getKiePMMLMiningModel {}", (Object)model);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        ArrayList<KiePMMLModel> nestedModels = new ArrayList<KiePMMLModel>();
        Map<String, String> sourcesMap = KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCompiled(fields, transformationDictionary, model, packageName, hasClassLoader, nestedModels);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLMiningModel = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLMiningModel)kiePMMLMiningModel.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLMiningModelSourcesMap(List<Field<?>> fields, TransformationDictionary transformationDictionary, MiningModel model, String parentPackageName, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.trace("getKiePMMLMiningModelSourcesMap {} {} {}", new Object[]{fields, model, parentPackageName});
        String segmentationName = String.format(SEGMENTATIONNAME_TEMPLATE, model.getModelName());
        Map<String, String> toReturn = KiePMMLSegmentationFactory.getSegmentationSourcesMap(parentPackageName, fields, transformationDictionary, model.getSegmentation(), segmentationName, hasClassloader, nestedModels);
        return KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCommon(fields, transformationDictionary, model, parentPackageName, toReturn);
    }

    public static Map<String, String> getKiePMMLMiningModelSourcesMapCompiled(List<Field<?>> fields, TransformationDictionary transformationDictionary, MiningModel model, String parentPackageName, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.trace("getKiePMMLMiningModelSourcesMapCompiled {} {} {}", new Object[]{fields, model, parentPackageName});
        Map<String, String> toReturn = KiePMMLSegmentationFactory.getSegmentationSourcesMapCompiled(parentPackageName, fields, transformationDictionary, model, hasClassloader, nestedModels);
        return KiePMMLMiningModelFactory.getKiePMMLMiningModelSourcesMapCommon(fields, transformationDictionary, model, parentPackageName, toReturn);
    }

    static Map<String, String> getKiePMMLMiningModelSourcesMapCommon(List<Field<?>> fields, TransformationDictionary transformationDictionary, MiningModel model, String parentPackageName, Map<String, String> toReturn) {
        logger.trace("getKiePMMLMiningModelSourcesMap {} {} {}", new Object[]{fields, model, parentPackageName});
        String segmentationName = String.format(SEGMENTATIONNAME_TEMPLATE, model.getModelName());
        String segmentationClass = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segmentationName)) + "." + KiePMMLModelUtils.getSanitizedClassName((String)segmentationName);
        if (!toReturn.containsKey(segmentationClass)) {
            throw new KiePMMLException("Expected generated class " + segmentationClass + " not found");
        }
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)parentPackageName, (String)KIE_PMML_MINING_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_MINING_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        KiePMMLMiningModelFactory.setConstructor(model, fields, transformationDictionary, modelTemplate, segmentationClass);
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(MiningModel miningModel, List<Field<?>> fields, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate, String segmentationClass) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, fields, (TransformationDictionary)transformationDictionary, (Model)miningModel);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        ClassOrInterfaceType kiePMMLSegmentationClass = StaticJavaParser.parseClassOrInterfaceType((String)segmentationClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(kiePMMLSegmentationClass);
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"segmentation", (Expression)objectCreationExpr);
    }
}

