/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.random.RandomUtils;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class ProbabilityValueSelector
extends AbstractValueSelector
implements EntityIndependentValueSelector,
SelectionCacheLifecycleListener {
    protected final EntityIndependentValueSelector childValueSelector;
    protected final SelectionCacheType cacheType;
    protected final SelectionProbabilityWeightFactory probabilityWeightFactory;
    protected NavigableMap<Double, Object> cachedEntityMap = null;
    protected double probabilityWeightTotal = -1.0;

    public ProbabilityValueSelector(EntityIndependentValueSelector childValueSelector, SelectionCacheType cacheType, SelectionProbabilityWeightFactory probabilityWeightFactory) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        this.probabilityWeightFactory = probabilityWeightFactory;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        this.cachedEntityMap = new TreeMap<Double, Object>();
        InnerScoreDirector scoreDirector = solverScope.getScoreDirector();
        double probabilityWeightOffset = 0.0;
        for (Object value : this.childValueSelector) {
            double probabilityWeight = this.probabilityWeightFactory.createProbabilityWeight(scoreDirector, value);
            this.cachedEntityMap.put(probabilityWeightOffset, value);
            probabilityWeightOffset += probabilityWeight;
        }
        this.probabilityWeightTotal = probabilityWeightOffset;
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.probabilityWeightTotal = -1.0;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return this.cachedEntityMap.size();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Object next() {
                double randomOffset = RandomUtils.nextDouble(ProbabilityValueSelector.this.workingRandom, ProbabilityValueSelector.this.probabilityWeightTotal);
                Map.Entry<Double, Object> entry = ProbabilityValueSelector.this.cachedEntityMap.floorEntry(randomOffset);
                return entry.getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The optional operation remove() is not supported.");
            }
        };
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    public String toString() {
        return "Probability(" + this.childValueSelector + ")";
    }
}

