/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.text.StrBuilder;
import org.kie.workbench.common.services.datamodeller.util.PortableStringUtils;

public class StringEscapeUtils {
    public static String escapeJava(String str) {
        return org.apache.commons.lang.StringEscapeUtils.escapeJava((String)str);
    }

    public static String unescapeJava(String str) {
        return org.apache.commons.lang.StringEscapeUtils.unescapeJava((String)str);
    }

    public static String unescapeJavaUTF(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringEscapeUtils.unescapeJavaUTF(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void unescapeJavaUTF(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StrBuilder unicode = new StrBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (ch == 'u') {
                    inUnicode = true;
                    continue;
                }
                out.write(92);
                out.write(ch);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.write(ch);
        }
        if (hadSlash) {
            out.write(92);
        }
    }

    public static String escapeJavaNonUTFChars(String str) {
        return StringEscapeUtils.escapeJavaNonUTFChars(str, false, false);
    }

    private static String escapeJavaNonUTFChars(String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            StringEscapeUtils.escapeJavaNonUTFChars(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void escapeJavaNonUTFChars(Writer out, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static String unquote(String str) {
        return PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(str, '\"'), '\"');
    }

    public static String unquoteSingle(String str) {
        return PortableStringUtils.removeLastChar(PortableStringUtils.removeFirstChar(str, '\''), '\'');
    }

    public static boolean isSingleQuoted(String str) {
        return str != null && str.length() >= 2 && str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'';
    }
}

