/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

import org.powermock.reflect.internal.WhiteboxImpl;

class ParametersMatcher {
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;
    private boolean isVarArgs;

    public ParametersMatcher(boolean isVarArgs, Class<?>[] parameterTypes, Object[] arguments) {
        this.isVarArgs = isVarArgs;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    public boolean match() {
        if (this.arguments != null && this.parameterTypes.length == this.arguments.length) {
            if (this.parameterTypes.length == 0) {
                return true;
            }
            return this.checkArgumentTypesMatchParameterTypes(this.isVarArgs, this.parameterTypes, this.arguments);
        }
        return this.doesParameterTypesMatchForVarArgsInvocation(this.arguments);
    }

    boolean checkArgumentTypesMatchParameterTypes(boolean isVarArgs, Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameter types cannot be null");
        }
        if (!isVarArgs && arguments.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            boolean isClass;
            Object argument = arguments[i];
            if (argument == null) {
                int index = i >= parameterTypes.length ? parameterTypes.length - 1 : i;
                Class<?> type = parameterTypes[index];
                if (!type.isPrimitive()) continue;
                return false;
            }
            if (i >= parameterTypes.length) {
                if (WhiteboxImpl.isAssignableFrom(parameterTypes[parameterTypes.length - 1], WhiteboxImpl.getType(argument))) continue;
                return false;
            }
            boolean assignableFrom = WhiteboxImpl.isAssignableFrom(parameterTypes[i], WhiteboxImpl.getType(argument));
            boolean bl = isClass = parameterTypes[i].equals(Class.class) && WhiteboxImpl.isClass(argument);
            if (assignableFrom || isClass) continue;
            return false;
        }
        return true;
    }

    boolean doesParameterTypesMatchForVarArgsInvocation(Object[] arguments) {
        if (this.isVarArgs && arguments != null && arguments.length >= 1 && this.parameterTypes != null && this.parameterTypes.length >= 1) {
            Class<?> componentType = this.parameterTypes[this.parameterTypes.length - 1].getComponentType();
            Object lastArgument = arguments[arguments.length - 1];
            if (lastArgument != null) {
                Class<?> lastArgumentTypeAsPrimitive = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(lastArgument);
                Class<?> varArgsParameterTypeAsPrimitive = WhiteboxImpl.getTypeAsPrimitiveIfWrapped(componentType);
                this.isVarArgs = varArgsParameterTypeAsPrimitive.isAssignableFrom(lastArgumentTypeAsPrimitive);
            }
        }
        return this.isVarArgs && this.checkArgumentTypesMatchParameterTypes(this.isVarArgs, this.parameterTypes, arguments);
    }
}

